/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;

public class BigDecimalFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = BigDecimalFormatter.class.getName() + ".message";

    public BigDecimalFormatter() {
        super(false);
    }

    public BigDecimalFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return BigDecimal.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getDecimalFormat();
    }

    @Override
    public BigDecimal parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            return new BigDecimal(number.toString());
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

