/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.DestroyException;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.TextBasedCrypto;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class TextDigester
extends TextBasedCrypto {
    private Digester digester;

    public TextDigester() {
    }

    public TextDigester(Digester digester) {
        this.digester = digester;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.digester, "digester is required.");
        this.textCharset = ValueUtils.valueOrAlt(this.textCharset, StandardCharsets.UTF_8);
        this.baseEncoder = ValueUtils.valueOrAlt(this.baseEncoder, BaseEncoder.BASE64);
    }

    public String digest(String message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return this.baseEncoder.encode(this.digester.digest(message.getBytes(this.textCharset)));
    }

    public boolean verify(String message, String digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        return this.digester.verify(message.getBytes(this.textCharset), this.baseEncoder.decode(digested));
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.digester != null) {
            this.digester.destroy();
        }
    }

    public TextDigester setDigester(Digester digester) {
        this.assertNotInitialized();
        this.digester = digester;
        return this;
    }

    @Override
    public TextDigester setTextCharset(Charset charset) {
        super.setTextCharset(charset);
        return this;
    }

    @Override
    public TextDigester setTextCharset(String textCharset) {
        super.setTextCharset(textCharset);
        return this;
    }

    @Override
    public TextDigester setBaseEncoder(BaseEncoder baseEncoder) {
        super.setBaseEncoder(baseEncoder);
        return this;
    }

    public TextDigester copy() {
        TextDigester impl = new TextDigester();
        impl.setTextCharset(this.textCharset).setBaseEncoder(this.baseEncoder);
        if (this.digester != null) {
            impl.digester = this.digester.copy();
        }
        return impl;
    }
}

