/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.PropertyConfig;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.PbeEncryptor;
import com.appslandia.common.crypto.TextEncryptor;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class SecureConfig
extends PropertyConfig {
    private static final long serialVersionUID = 1L;
    final TextEncryptor textEncryptor;

    public SecureConfig(char[] password) {
        AssertUtils.assertNotNull(password);
        this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(32).setPassword(password));
    }

    public SecureConfig(String password) {
        AssertUtils.assertNotNull(password);
        this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(32).setPassword(password));
    }

    public SecureConfig(Encryptor encryptor) {
        AssertUtils.assertNotNull(encryptor);
        this.textEncryptor = new TextEncryptor(encryptor);
    }

    public SecureConfig(TextEncryptor textEncryptor) {
        AssertUtils.assertNotNull(textEncryptor);
        this.textEncryptor = textEncryptor;
    }

    @Override
    public SecureConfig load(InputStream is) throws IOException {
        super.load(is);
        return this;
    }

    @Override
    public SecureConfig load(Reader r) throws IOException {
        super.load(r);
        return this;
    }

    @Override
    public SecureConfig load(File file) throws IOException {
        super.load(file);
        return this;
    }

    @Override
    public SecureConfig load(String file) throws IOException {
        super.load(file);
        return this;
    }

    @Override
    public String getString(String key) {
        String value = super.getString(key);
        if (value == null) {
            return null;
        }
        if (!CryptoUtils.isEncValue(value)) {
            return value;
        }
        return this.textEncryptor.decrypt(CryptoUtils.parseEncValue(value));
    }

    @Override
    public SecureConfig set(String key, String value) {
        super.set(key, value);
        return this;
    }

    @Override
    public SecureConfig set(String key, boolean value) {
        super.set(key, value);
        return this;
    }

    @Override
    public SecureConfig set(String key, int value) {
        super.set(key, value);
        return this;
    }

    @Override
    public SecureConfig set(String key, long value) {
        super.set(key, value);
        return this;
    }

    @Override
    public SecureConfig set(String key, double value) {
        super.set(key, value);
        return this;
    }

    public SecureConfig enc(String key, String value) throws CryptoException {
        this.map.put(key, (value = StringUtils.trimToNull(value)) != null ? CryptoUtils.markEncValue(this.textEncryptor.encrypt(value)) : null);
        return this;
    }

    public SecureConfig enc(String key, boolean value) throws CryptoException {
        this.map.put(key, CryptoUtils.markEncValue(this.textEncryptor.encrypt(Boolean.toString(value))));
        return this;
    }

    public SecureConfig enc(String key, int value) throws CryptoException {
        this.map.put(key, CryptoUtils.markEncValue(this.textEncryptor.encrypt(Integer.toString(value))));
        return this;
    }

    public SecureConfig enc(String key, long value) throws CryptoException {
        this.map.put(key, CryptoUtils.markEncValue(this.textEncryptor.encrypt(Long.toString(value))));
        return this;
    }

    public SecureConfig enc(String key, float value) throws CryptoException {
        this.map.put(key, CryptoUtils.markEncValue(this.textEncryptor.encrypt(Float.toString(value))));
        return this;
    }

    public SecureConfig enc(String key, double value) throws CryptoException {
        this.map.put(key, CryptoUtils.markEncValue(this.textEncryptor.encrypt(Double.toString(value))));
        return this;
    }
}

