/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Out;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.KeyFactoryUtil;
import com.appslandia.common.utils.AssertUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class RsaEncryptor
extends InitializeObject
implements Encryptor {
    private String transformation;
    private String provider;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private Cipher encrypt;
    private Cipher decrypt;
    final Object encMutex = new Object();
    final Object decMutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.transformation, "transformation is required.");
        String[] trans = this.transformation.split("/");
        AssertUtils.assertTrue("RSA".equalsIgnoreCase(trans[0]), "RSA algorithm is required.");
        String padding = trans.length == 3 ? trans[2] : null;
        AlgorithmParameterSpec paramSpec = padding != null ? RsaEncryptor.parseParamSpec(padding) : null;
        AssertUtils.assertTrue(this.privateKey != null || this.publicKey != null, "No key is provided.");
        if (this.publicKey != null) {
            this.encrypt = this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
            this.encrypt.init(1, (Key)this.publicKey, paramSpec);
        }
        if (this.privateKey != null) {
            this.decrypt = this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
            this.decrypt.init(2, (Key)this.privateKey, paramSpec);
        }
    }

    @Override
    public void destroy() throws DestroyException {
        CryptoUtils.destroyQuietly(this.privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(this.encrypt, "publicKey is required.");
        try {
            Object object = this.encMutex;
            synchronized (object) {
                return this.encrypt.doFinal(message);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(this.decrypt, "privateKey is required.");
        try {
            Object object = this.decMutex;
            synchronized (object) {
                return this.decrypt.doFinal(message);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] message, Out<byte[]> salt) throws CryptoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] decrypt(byte[] message, byte[] salt) throws CryptoException {
        throw new UnsupportedOperationException();
    }

    public RsaEncryptor setTransformation(String transformation) {
        this.assertNotInitialized();
        this.transformation = transformation;
        return this;
    }

    public RsaEncryptor setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    public RsaEncryptor setPrivateKey(PrivateKey privateKey) {
        this.assertNotInitialized();
        this.privateKey = privateKey;
        return this;
    }

    public RsaEncryptor setPrivateKey(String privateKeyPem) {
        this.assertNotInitialized();
        if (privateKeyPem != null) {
            this.privateKey = KeyFactoryUtil.RSA.toPrivateKey(privateKeyPem);
        }
        return this;
    }

    public RsaEncryptor setPublicKey(PublicKey publicKey) {
        this.assertNotInitialized();
        this.publicKey = publicKey;
        return this;
    }

    public RsaEncryptor setPublicKey(String publicKeyPem) {
        this.assertNotInitialized();
        if (publicKeyPem != null) {
            this.publicKey = KeyFactoryUtil.RSA.toPublicKey(publicKeyPem);
        }
        return this;
    }

    @Override
    public RsaEncryptor copy() {
        RsaEncryptor impl = new RsaEncryptor().setTransformation(this.transformation).setProvider(this.provider);
        if (this.privateKey != null) {
            impl.privateKey = new KeyFactoryUtil(this.privateKey.getAlgorithm()).copy(this.privateKey);
        }
        impl.publicKey = this.publicKey;
        return impl;
    }

    static AlgorithmParameterSpec parseParamSpec(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("NoPadding") || padding.equalsIgnoreCase("PKCS1Padding")) {
            return null;
        }
        if (padding.equalsIgnoreCase("OAEPPadding")) {
            return OAEPParameterSpec.DEFAULT;
        }
        if (padding.equalsIgnoreCase("OAEPWithMD5AndMGF1Padding")) {
            return new OAEPParameterSpec("MD5", "MGF1", new MGF1ParameterSpec("MD5"), PSource.PSpecified.DEFAULT);
        }
        if (padding.equalsIgnoreCase("OAEPWithSHA-1AndMGF1Padding")) {
            return new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
        }
        if (padding.equalsIgnoreCase("OAEPWithSHA-224AndMGF1Padding")) {
            return new OAEPParameterSpec("SHA-224", "MGF1", MGF1ParameterSpec.SHA224, PSource.PSpecified.DEFAULT);
        }
        if (padding.equalsIgnoreCase("OAEPWithSHA-256AndMGF1Padding")) {
            return new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        }
        if (padding.equalsIgnoreCase("OAEPWithSHA-384AndMGF1Padding")) {
            return new OAEPParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, PSource.PSpecified.DEFAULT);
        }
        if (padding.equalsIgnoreCase("OAEPWithSHA-512AndMGF1Padding")) {
            return new OAEPParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, PSource.PSpecified.DEFAULT);
        }
        throw new NoSuchPaddingException(padding + " unavailable with RSA.");
    }
}

