/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Out;
import com.appslandia.common.base.RoundRobinPool;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;

public class PoolEncryptor
extends InitializeObject
implements Encryptor {
    private Encryptor encryptor;
    private int poolSize;
    private Encryptor[] encryptors;
    private RoundRobinPool<Encryptor> encryptorPool;

    public PoolEncryptor() {
    }

    public PoolEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public PoolEncryptor(Encryptor encryptor, int poolSize) {
        this.encryptor = encryptor;
        this.poolSize = poolSize;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.encryptor, "encryptor is required.");
        this.poolSize = ValueUtils.valueOrMin(this.poolSize, Runtime.getRuntime().availableProcessors());
        this.encryptors = new Encryptor[this.poolSize];
        this.encryptors[0] = this.encryptor;
        for (int i = 1; i < this.poolSize; ++i) {
            this.encryptors[i] = this.encryptor.copy();
        }
        this.encryptorPool = new RoundRobinPool<Encryptor>(this.encryptors);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.encryptors != null) {
            for (Encryptor enc : this.encryptors) {
                enc.destroy();
            }
        }
    }

    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return this.encryptorPool.next().encrypt(message);
    }

    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return this.encryptorPool.next().decrypt(message);
    }

    @Override
    public byte[] encrypt(byte[] message, Out<byte[]> salt) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(salt, "salt is required.");
        return this.encryptorPool.next().encrypt(message, salt);
    }

    @Override
    public byte[] decrypt(byte[] message, byte[] salt) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(salt, "salt is required.");
        return this.encryptorPool.next().decrypt(message, salt);
    }

    public PoolEncryptor setEncryptor(Encryptor encryptor) {
        this.assertNotInitialized();
        this.encryptor = encryptor;
        return this;
    }

    public PoolEncryptor setPoolSize(int poolSize) {
        this.assertNotInitialized();
        this.poolSize = poolSize;
        return this;
    }

    @Override
    public PoolEncryptor copy() {
        PoolEncryptor impl = new PoolEncryptor().setPoolSize(this.poolSize);
        if (this.encryptor != null) {
            impl.encryptor = this.encryptor.copy();
        }
        return impl;
    }
}

