/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.SYS;
import com.appslandia.common.utils.ValueUtils;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class PbeObject
extends InitializeObject {
    protected int saltSize;
    protected int iterationCount;
    protected int keySize;
    protected char[] password;
    protected SecretKeyGenerator secretKeyGenerator;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.keySize > 0, "keySize is required.");
        this.saltSize = ValueUtils.valueOrAlt(this.saltSize, this.keySize);
        this.iterationCount = ValueUtils.valueOrMin(this.iterationCount, 10000);
        AssertUtils.assertNotNull(this.password, "password is required.");
        if (this.secretKeyGenerator == null) {
            this.secretKeyGenerator = new SecretKeyGenerator();
        }
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.password != null) {
            CryptoUtils.clear(this.password);
        }
    }

    protected SecretKey buildSecretKey(byte[] salt, String algorithm) throws CryptoException {
        byte[] key = this.secretKeyGenerator.generate(this.password, salt, this.iterationCount, this.keySize);
        SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
        CryptoUtils.clear(key);
        return secretKey;
    }

    public PbeObject setSaltSize(int saltSize) {
        this.assertNotInitialized();
        this.saltSize = saltSize;
        return this;
    }

    public PbeObject setIterationCount(int iterationCount) {
        this.assertNotInitialized();
        this.iterationCount = iterationCount;
        return this;
    }

    public PbeObject setKeySize(int keySize) {
        this.assertNotInitialized();
        this.keySize = keySize;
        return this;
    }

    public PbeObject setPassword(char[] password) {
        this.assertNotInitialized();
        if (password != null) {
            this.password = Arrays.copyOf(password, password.length);
        }
        return this;
    }

    public PbeObject setPassword(String passwordOrEnv) {
        this.assertNotInitialized();
        if (passwordOrEnv != null) {
            String resolvedValue = SYS.resolveExpr(passwordOrEnv);
            this.password = resolvedValue.toCharArray();
        }
        return this;
    }

    public PbeObject setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        this.assertNotInitialized();
        this.secretKeyGenerator = secretKeyGenerator;
        return this;
    }
}

