/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.Out;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.PbeObject;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class PbeDigester
extends PbeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Mac mac;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.mac = this.provider == null ? Mac.getInstance(this.algorithm) : Mac.getInstance(this.algorithm, this.provider);
    }

    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        Out<byte[]> salt = new Out<byte[]>();
        byte[] msgMac = this.digest(message, salt);
        return ArrayUtils.append((byte[])salt.value, msgMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] saltHmac) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(saltHmac, "saltHmac is required.");
        AssertUtils.assertTrue(saltHmac.length > this.saltSize, "digested is invalid.");
        byte[] salt = new byte[this.saltSize];
        ArrayUtils.copy(saltHmac, salt);
        SecretKey secretKey = this.buildSecretKey(salt, this.algorithm);
        try {
            byte[] msgMac = null;
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
            boolean bl = ArrayUtils.endsWith(saltHmac, msgMac, this.saltSize);
            return bl;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message, Out<byte[]> salt) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(salt, "salt is required.");
        salt.value = RandomUtils.nextBytes(this.saltSize, this.random);
        SecretKey secretKey = this.buildSecretKey((byte[])salt.value, this.algorithm);
        try {
            byte[] msgMac = null;
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
            object = msgMac;
            return object;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] hmac, byte[] salt) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(hmac, "hmac is required.");
        AssertUtils.assertNotNull(salt, "salt is required.");
        SecretKey secretKey = this.buildSecretKey(salt, this.algorithm);
        try {
            byte[] msgMac = null;
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
            boolean bl = Arrays.equals(hmac, msgMac);
            return bl;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    public PbeDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public PbeDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    @Override
    public PbeDigester setSaltSize(int saltSize) {
        super.setSaltSize(saltSize);
        return this;
    }

    @Override
    public PbeDigester setIterationCount(int iterationCount) {
        super.setIterationCount(iterationCount);
        return this;
    }

    @Override
    public PbeDigester setKeySize(int keySize) {
        super.setKeySize(keySize);
        return this;
    }

    @Override
    public PbeDigester setPassword(char[] password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public PbeDigester setPassword(String passwordOrEnv) {
        super.setPassword(passwordOrEnv);
        return this;
    }

    @Override
    public PbeDigester setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        super.setSecretKeyGenerator(secretKeyGenerator);
        return this;
    }

    @Override
    public PbeDigester copy() {
        PbeDigester impl = new PbeDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        impl.setSaltSize(this.saltSize).setIterationCount(this.iterationCount).setKeySize(this.keySize);
        if (this.password != null) {
            impl.setPassword(this.password);
        }
        if (this.secretKeyGenerator != null) {
            impl.secretKeyGenerator = this.secretKeyGenerator.copy();
        }
        return impl;
    }
}

