/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Pattern;

public class PasswordUtil {
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[$@&#!?*%:+-]).{8,128}");
    private static final char[] ALPHABET_SYMBOLS = "$@&#!?*%:+-".toCharArray();
    private static final char[] ALPHABET_UPPER = CharUtils.toCharRanges("A-Z");
    private static final char[] ALPHABET_LOWER = CharUtils.toCharRanges("a-z");
    private static final char[] ALPHABET_DIGITS = CharUtils.toCharRanges("0-9");
    private static final char[][] ALPHABET = new char[][]{ALPHABET_SYMBOLS, ALPHABET_UPPER, ALPHABET_LOWER, ALPHABET_DIGITS};
    final Random random = new SecureRandom();

    public char[] generatePassword(int minLength, int maxLength) {
        AssertUtils.assertTrue(minLength <= maxLength, "minLength <= maxLength");
        AssertUtils.assertTrue(minLength >= 8, "minLength >= 8");
        int length = RandomUtils.nextInt(minLength, maxLength, this.random);
        return CharUtils.randomChars(length, ALPHABET, this.random);
    }

    public static boolean isValid(String password) {
        AssertUtils.assertNotNull(password);
        return PASSWORD_PATTERN.matcher(password).matches();
    }

    public static char[] generatePassword(int length) {
        return new PasswordUtil().generatePassword(length, length);
    }
}

