/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.StringWriter;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class PKIUtils {
    public static byte[] toDerEncoded(String pem) {
        pem = PKIUtils.removeBeginEnd(pem);
        return BaseEncoder.BASE64_MIME.decode(pem);
    }

    public static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)-----", "");
        return pem.trim();
    }

    public static String toPemEncoded(byte[] der, String label) {
        StringWriter pem = new StringWriter(der.length * 4 / 3 + 128);
        PrintWriter pw = new PrintWriter(pem);
        pw.append("-----BEGIN ").append(label).println("-----");
        pw.write(BaseEncoder.BASE64_MIME.encode(der));
        pw.println();
        pw.append("-----END ").append(label).println("-----");
        pw.close();
        return pem.toString();
    }

    public static String toPemLabel(PublicKey key) {
        return key.getAlgorithm() + " PUBLIC KEY";
    }

    public static String toPemLabel(PrivateKey key) {
        return key.getAlgorithm() + " PRIVATE KEY";
    }

    public static String toPemEncoded(PublicKey key) {
        return PKIUtils.toPemEncoded(key.getEncoded(), PKIUtils.toPemLabel(key));
    }

    public static String toPemEncoded(PrivateKey key) {
        return PKIUtils.toPemEncoded(key.getEncoded(), PKIUtils.toPemLabel(key));
    }

    public static String toPemLabel(Certificate cert) {
        return cert.getType() + " CERTIFICATE";
    }

    public static String toPemEncoded(Certificate cert) throws CertificateEncodingException {
        return PKIUtils.toPemEncoded(cert.getEncoded(), PKIUtils.toPemLabel(cert));
    }
}

