/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Out;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.SYS;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MacDigester
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Mac mac;
    private byte[] secret;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        AssertUtils.assertNotNull(this.secret, "secret is required.");
        this.mac = this.provider == null ? Mac.getInstance(this.algorithm) : Mac.getInstance(this.algorithm, this.provider);
        this.mac.init(new SecretKeySpec(this.secret, this.algorithm));
        CryptoUtils.clear(this.secret);
    }

    @Override
    public void destroy() throws DestroyException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        Object object = this.mutex;
        synchronized (object) {
            return this.mac.doFinal(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] hmac) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(hmac, "hmac is required.");
        byte[] msgMac = null;
        Object object = this.mutex;
        synchronized (object) {
            msgMac = this.mac.doFinal(message);
        }
        return Arrays.equals(hmac, msgMac);
    }

    @Override
    public byte[] digest(byte[] message, Out<byte[]> salt) throws CryptoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean verify(byte[] message, byte[] hmac, byte[] salt) throws CryptoException {
        throw new UnsupportedOperationException();
    }

    public MacDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public MacDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    public MacDigester setSecret(byte[] secret) {
        this.assertNotInitialized();
        if (secret != null) {
            this.secret = ArrayUtils.copy(secret);
        }
        return this;
    }

    public MacDigester setSecret(String secretOrEnv) {
        this.assertNotInitialized();
        if (secretOrEnv != null) {
            String resolvedValue = SYS.resolveExpr(secretOrEnv);
            this.secret = resolvedValue.getBytes(StandardCharsets.UTF_8);
        }
        return this;
    }

    @Override
    public MacDigester copy() {
        MacDigester impl = new MacDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        impl.secret = ArrayUtils.copy(this.secret);
        return impl;
    }
}

