/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.PKIUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactoryUtil
extends InitializeObject {
    public static final KeyFactoryUtil DSA = new KeyFactoryUtil("DSA");
    public static final KeyFactoryUtil RSA = new KeyFactoryUtil("RSA");
    private String algorithm;
    private String provider;
    private KeyFactory keyFactory;
    final Object mutex = new Object();

    public KeyFactoryUtil() {
    }

    public KeyFactoryUtil(String algorithm) {
        this.algorithm = algorithm;
    }

    public KeyFactoryUtil(String algorithm, String provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.keyFactory = this.provider == null ? KeyFactory.getInstance(this.algorithm) : KeyFactory.getInstance(this.algorithm, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey toPrivateKey(String keyInPem) throws CryptoException {
        this.initialize();
        byte[] der = PKIUtils.toDerEncoded(keyInPem);
        try {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    PrivateKey privateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(der));
                    return privateKey;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new CryptoException(ex);
                    }
                }
            }
        }
        finally {
            CryptoUtils.clear(der);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey toPrivateKey(InputStream keyInDer) throws IOException, CryptoException {
        this.initialize();
        byte[] der = IOUtils.toByteArray(keyInDer);
        try {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    PrivateKey privateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(der));
                    return privateKey;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new CryptoException(ex);
                    }
                }
            }
        }
        finally {
            CryptoUtils.clear(der);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey toPublicKey(String keyInPem) throws CryptoException {
        this.initialize();
        byte[] der = PKIUtils.toDerEncoded(keyInPem);
        try {
            Object object = this.mutex;
            synchronized (object) {
                return this.keyFactory.generatePublic(new X509EncodedKeySpec(der));
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey toPublicKey(InputStream keyInDer) throws IOException, CryptoException {
        this.initialize();
        try {
            Object object = this.mutex;
            synchronized (object) {
                return this.keyFactory.generatePublic(new X509EncodedKeySpec(IOUtils.toByteArray(keyInDer)));
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey copy(PrivateKey key) throws CryptoException {
        this.initialize();
        AssertUtils.assertTrue("PKCS#8".equals(key.getFormat()), "key is not PKCS#8 format.");
        byte[] der = key.getEncoded();
        try {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    PrivateKey privateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(der));
                    return privateKey;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new CryptoException(ex);
                    }
                }
            }
        }
        finally {
            CryptoUtils.clear(der);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey copy(PublicKey key) throws CryptoException {
        this.initialize();
        AssertUtils.assertTrue("X.509".equals(key.getFormat()), "key is not X.509 format.");
        try {
            Object object = this.mutex;
            synchronized (object) {
                return this.keyFactory.generatePublic(new X509EncodedKeySpec(key.getEncoded()));
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public KeyFactoryUtil setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public KeyFactoryUtil setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }
}

