/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Out;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.utils.AssertUtils;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigesterImpl
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private MessageDigest digest;
    final Object mutex = new Object();

    public DigesterImpl() {
    }

    public DigesterImpl(String algorithm) {
        this.algorithm = algorithm;
    }

    public DigesterImpl(String algorithm, String provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.digest = this.provider == null ? MessageDigest.getInstance(this.algorithm) : MessageDigest.getInstance(this.algorithm, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        Object object = this.mutex;
        synchronized (object) {
            return this.digest.digest(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] hash) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(hash, "hash is required.");
        byte[] digest = null;
        Object object = this.mutex;
        synchronized (object) {
            digest = this.digest.digest(message);
        }
        return Arrays.equals(hash, digest);
    }

    @Override
    public byte[] digest(byte[] message, Out<byte[]> salt) throws CryptoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean verify(byte[] message, byte[] digested, byte[] salt) throws CryptoException {
        throw new UnsupportedOperationException();
    }

    public DigesterImpl setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public DigesterImpl setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    @Override
    public DigesterImpl copy() {
        return new DigesterImpl().setAlgorithm(this.algorithm).setProvider(this.provider);
    }
}

