/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.PKIUtils;
import com.appslandia.common.utils.ValueUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateFactoryUtil
extends InitializeObject {
    public static final CertificateFactoryUtil X509 = new CertificateFactoryUtil("X.509");
    private String type;
    private String provider;
    private CertificateFactory certificateFactory;
    final Object mutex = new Object();

    public CertificateFactoryUtil() {
    }

    public CertificateFactoryUtil(String type) {
        this.type = type;
    }

    public CertificateFactoryUtil(String type, String provider) {
        this.type = type;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        this.type = ValueUtils.valueOrAlt(this.type, "X.509");
        this.certificateFactory = this.provider == null ? CertificateFactory.getInstance(this.type) : CertificateFactory.getInstance(this.type, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate toCertificate(InputStream certInDer) throws CryptoException {
        this.initialize();
        try {
            Object object = this.mutex;
            synchronized (object) {
                return (X509Certificate)this.certificateFactory.generateCertificate(certInDer);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate toCertificate(String certInPem) throws CryptoException {
        this.initialize();
        byte[] der = PKIUtils.toDerEncoded(certInPem);
        try {
            Object object = this.mutex;
            synchronized (object) {
                return (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(der));
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public CertificateFactoryUtil setType(String type) {
        this.assertNotInitialized();
        this.type = type;
        return this;
    }

    public CertificateFactoryUtil setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }
}

