/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.cdi.BeanInstance;
import com.appslandia.common.cdi.CDIFactory;
import com.appslandia.common.cdi.CDISupplier;
import com.appslandia.common.cdi.Supplier;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import jakarta.el.ELProcessor;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class CDIUtils {
    public static <T> BeanInstance<T> getReference(BeanManager beanManager, Class<? extends T> type) {
        return CDIUtils.getReference(beanManager, type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public static <T> BeanInstance<T> getReference(BeanManager beanManager, Class<? extends T> type, Annotation ... qualifiers) {
        Set matchedBeans = beanManager.getBeans(type, qualifiers);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(matchedBeans);
        if (bean == null) {
            return null;
        }
        CreationalContext ctx = (CreationalContext)ObjectUtils.cast(beanManager.createCreationalContext((Contextual)bean));
        Object t = ObjectUtils.cast(beanManager.getReference(bean, type, ctx));
        return new BeanInstance(t, ctx);
    }

    public static <T> BeanInstance<T> getReference(BeanManager beanManager, String name) {
        Set matchedBeans = beanManager.getBeans(name);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(matchedBeans);
        if (bean == null) {
            return null;
        }
        CreationalContext ctx = (CreationalContext)ObjectUtils.cast(beanManager.createCreationalContext((Contextual)bean));
        Object t = ObjectUtils.cast(beanManager.getReference(bean, (Type)bean.getBeanClass(), ctx));
        return new BeanInstance(t, ctx);
    }

    public static <T, A extends Annotation> void scanReferences(BeanManager beanManager, Class<T> type, Annotation[] qualifiers, Class<A> annotationClass, BiConsumer<A, BeanInstance<T>> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(type, qualifiers));
        for (Bean bean : beans) {
            if (annotationClass == null) {
                CreationalContext ctx = (CreationalContext)ObjectUtils.cast(beanManager.createCreationalContext((Contextual)bean));
                Object t = ObjectUtils.cast(beanManager.getReference(bean, type, ctx));
                consumer.accept(null, new BeanInstance(t, ctx));
                continue;
            }
            A annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
            if (annotation == null && CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                annotation = factoryMethod.getDeclaredAnnotation(annotationClass);
            }
            if (annotation == null) continue;
            CreationalContext ctx = (CreationalContext)ObjectUtils.cast(beanManager.createCreationalContext((Contextual)bean));
            Object t = ObjectUtils.cast(beanManager.getReference(bean, type, ctx));
            consumer.accept(annotation, new BeanInstance(t, ctx));
        }
    }

    public static void scanSuppliers(BeanManager beanManager, Annotation[] qualifiers, Class<?> constraintType, Consumer<BeanInstance<CDISupplier>> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(CDISupplier.class, qualifiers));
        for (Bean bean : beans) {
            Supplier supplier = bean.getBeanClass().getDeclaredAnnotation(Supplier.class);
            if (supplier == null && CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                supplier = factoryMethod.getDeclaredAnnotation(Supplier.class);
            }
            if (supplier == null || supplier.value() != constraintType) continue;
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            CDISupplier t = (CDISupplier)ObjectUtils.cast(beanManager.getReference(bean, CDISupplier.class, ctx));
            consumer.accept(new BeanInstance<CDISupplier>(t, ctx));
        }
    }

    public static <T, A extends Annotation> void scanBeanClasses(BeanManager beanManager, Class<T> type, Annotation[] qualifiers, Class<A> annotationClass, BiConsumer<A, Class<?>> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(type, qualifiers));
        for (Bean bean : beans) {
            A annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
            if (annotation == null && CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                annotation = factoryMethod.getDeclaredAnnotation(annotationClass);
            }
            if (annotation == null) continue;
            consumer.accept(annotation, bean.getBeanClass());
        }
    }

    public static Method getFactoryMethod(Class<? extends CDIFactory<?>> factoryClass) {
        try {
            return factoryClass.getMethod("produce", new Class[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Annotation getImpl(Class<? extends Annotation> qualifier) {
        try {
            Field impl = qualifier.getDeclaredField("IMPL");
            AssertUtils.assertTrue(ReflectionUtils.isPublicConst(impl.getModifiers()));
            return (Annotation)impl.get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Annotated annotated, Class<A> annotationType) {
        if (annotated.getAnnotations().isEmpty()) {
            return null;
        }
        if (annotated.isAnnotationPresent(annotationType)) {
            return (A)annotated.getAnnotation(annotationType);
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(annotated.getAnnotations());
        return CDIUtils.getAnnotation(beanManager, annotationType, annotations);
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<?> annotatedClass, Class<A> annotationType) {
        if (annotatedClass.isAnnotationPresent(annotationType)) {
            return annotatedClass.getAnnotation(annotationType);
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        CollectionUtils.toList(new Object[]{annotations, annotatedClass.getAnnotations()});
        return CDIUtils.getAnnotation(beanManager, annotationType, annotations);
    }

    static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationType, Queue<Annotation> annotations) {
        while (!annotations.isEmpty()) {
            Annotation annotation = annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return (A)((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return null;
    }

    public static ELProcessor getELProcessor(BeanManager beanManager) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(beanManager.getELResolver());
        return elProcessor;
    }
}

