/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.GroupFormat;
import com.appslandia.common.base.TextGenerator;
import com.appslandia.common.utils.AssertUtils;
import java.util.UUID;

public class UUIDGenerator
implements TextGenerator {
    public static final UUIDGenerator INSTANCE = new UUIDGenerator();
    static final GroupFormat UUID_FORMAT = new GroupFormat("{8}-{4}-{4}-{4}-{12}");

    @Override
    public String generate() {
        UUID uuid = UUID.randomUUID();
        return UUIDGenerator.digits(uuid.getMostSignificantBits() >> 32, 8) + UUIDGenerator.digits(uuid.getMostSignificantBits() >> 16, 4) + UUIDGenerator.digits(uuid.getMostSignificantBits(), 4) + UUIDGenerator.digits(uuid.getLeastSignificantBits() >> 48, 4) + UUIDGenerator.digits(uuid.getLeastSignificantBits(), 12);
    }

    @Override
    public boolean verify(String value) {
        AssertUtils.assertNotNull(value);
        if (value.length() != 32) {
            return false;
        }
        try {
            String uuid = UUID_FORMAT.format(value);
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

