/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.TextGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.MathUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Pattern;

public class TokenGenerator
extends InitializeObject
implements TextGenerator {
    private static final Pattern BASE64_URL_NP_PATTERN = Pattern.compile("[a-zA-Z\\d-_]+");
    private int length = 32;
    final Random random = new SecureRandom();

    public TokenGenerator() {
    }

    public TokenGenerator(int length) {
        this.length = length;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.length > 0, "length is required.");
    }

    @Override
    public String generate() {
        this.initialize();
        int len = MathUtils.ceil(this.length, 4);
        byte[] bytes = RandomUtils.nextBytes(len * 3 / 4, this.random);
        String base64 = BaseEncoder.BASE64_URL_NP.encode(bytes);
        return base64.length() == this.length ? base64 : base64.substring(0, this.length);
    }

    @Override
    public boolean verify(String value) {
        AssertUtils.assertNotNull(value);
        if (value.length() != this.length) {
            return false;
        }
        return BASE64_URL_NP_PATTERN.matcher(value).matches();
    }

    public TokenGenerator setLength(int length) {
        this.assertNotInitialized();
        this.length = length;
        return this;
    }
}

