/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.StringFormat;
import java.io.Serializable;
import java.util.regex.Pattern;

public class RateLimit
implements Serializable {
    private static final long serialVersionUID = 1L;
    final double accesses;
    final long windowsMs;
    static final Pattern RATE_LIMIT_PATTERN = Pattern.compile("(\\d+.\\d+|\\d+)\\s*/\\s*\\d+(w|d|h|m|s|ms)", 2);

    public RateLimit(double accesses, long windowsMs) {
        this.accesses = accesses;
        this.windowsMs = windowsMs;
    }

    public double getAccesses() {
        return this.accesses;
    }

    public long getWindowMs() {
        return this.windowsMs;
    }

    public double getRatePerMs() {
        return this.accesses / (double)this.windowsMs;
    }

    public String toString() {
        return StringFormat.fmt("RateLimit: accesses={}, windowsMs={}", this.accesses, this.windowsMs);
    }

    public static RateLimit parse(String rateLimit) throws IllegalArgumentException {
        if (!RATE_LIMIT_PATTERN.matcher(rateLimit).matches()) {
            throw new IllegalArgumentException("rateLimit is invalid (value=" + rateLimit + ")");
        }
        int idx = rateLimit.indexOf(47);
        double accesses = Double.parseDouble(rateLimit.substring(0, idx).trim());
        long windowsMs = DateUtils.translateToMs(rateLimit.substring(idx + 1).trim());
        if (accesses == 0.0) {
            throw new IllegalArgumentException("accesses must be positive (rateLimit=" + rateLimit + ")");
        }
        if (windowsMs == 0L) {
            throw new IllegalArgumentException("windowsMs must be positive (rateLimit=" + rateLimit + ")");
        }
        return new RateLimit(accesses, windowsMs);
    }
}

