/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.ConfigMap;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.utils.ExceptionUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyConfig
extends ConfigMap
implements Serializable {
    private static final long serialVersionUID = 1L;

    public PropertyConfig() {
        super((Map<String, String>)new LinkedHashMap<String, String>());
    }

    public PropertyConfig(Map<String, String> newMap) {
        super(newMap);
    }

    public PropertyConfig load(InputStream is) throws IOException {
        LinkedProperties props = new LinkedProperties();
        props.load(is);
        this.fromProperties(props);
        return this;
    }

    public PropertyConfig load(Reader r) throws IOException {
        LinkedProperties props = new LinkedProperties();
        props.load(r);
        this.fromProperties(props);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyConfig load(File file) throws IOException {
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            PropertyConfig propertyConfig = this.load(br);
            return propertyConfig;
        }
    }

    public PropertyConfig load(String file) throws IOException {
        return this.load(new File(file));
    }

    protected void fromProperties(Properties props) {
        for (Object prop : props.keySet()) {
            String key = (String)prop;
            String value = (String)props.get(key);
            if (key.isEmpty()) continue;
            this.map.put(key, !value.isEmpty() ? value : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, String comments) throws IOException {
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            this.store(bw, comments);
        }
    }

    public void store(String file, String comments) throws IOException {
        this.store(new File(file), comments);
    }

    public void store(OutputStream os, String comments) throws IOException {
        this.toProperties().store(os, comments);
    }

    public void store(Writer w, String comments) throws IOException {
        this.toProperties().store(w, comments);
    }

    protected Properties toProperties() {
        LinkedProperties props = new LinkedProperties();
        for (Map.Entry prop : this.map.entrySet()) {
            ((Properties)props).put(prop.getKey(), prop.getValue() != null ? prop.getValue() : "");
        }
        return props;
    }

    @Override
    public PropertyConfig set(String key, String value) {
        super.set(key, value);
        return this;
    }

    @Override
    public PropertyConfig set(String key, boolean value) {
        super.set(key, value);
        return this;
    }

    @Override
    public PropertyConfig set(String key, int value) {
        super.set(key, value);
        return this;
    }

    @Override
    public PropertyConfig set(String key, long value) {
        super.set(key, value);
        return this;
    }

    @Override
    public PropertyConfig set(String key, double value) {
        super.set(key, value);
        return this;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            this.store(out, this.getClass().getName());
            return out.toString();
        }
        catch (IOException ex) {
            return ExceptionUtils.toStackTrace(ex);
        }
    }

    private static class LinkedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        final Set<Object> keys = new LinkedHashSet<Object>();

        private LinkedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

