/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.StringFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MemoryStream
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int blockSize;
    private NodeList nodeList;
    private long count;
    private int lastLen;

    public MemoryStream() {
        this(512);
    }

    public MemoryStream(int blockSize) {
        AssertUtils.assertTrue(blockSize > 0);
        this.blockSize = blockSize;
        this.nodeList = new NodeList(new byte[this.blockSize]);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] lastBuf = this.nodeList.last.buf;
        int lenAv = lastBuf.length - this.lastLen;
        if (lenAv >= 1) {
            lastBuf[this.lastLen] = (byte)b;
            ++this.lastLen;
        } else {
            this.nodeList.insert(new byte[this.blockSize]);
            this.nodeList.last.buf[0] = (byte)b;
            this.lastLen = 1;
        }
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] lastBuf = this.nodeList.last.buf;
        int lenAv = lastBuf.length - this.lastLen;
        if (lenAv >= len) {
            System.arraycopy(b, off, lastBuf, this.lastLen, len);
            this.lastLen += len;
        } else {
            int addLen = len - lenAv;
            int addBlk = addLen / this.blockSize;
            if (addBlk * this.blockSize < addLen) {
                ++addBlk;
            }
            this.nodeList.insert(new byte[addBlk * this.blockSize]);
            if (lenAv == 0) {
                System.arraycopy(b, off, this.nodeList.last.buf, 0, len);
                this.lastLen = len;
            } else {
                System.arraycopy(b, off, lastBuf, this.lastLen, lenAv);
                System.arraycopy(b, off + lenAv, this.nodeList.last.buf, 0, len - lenAv);
                this.lastLen = len - lenAv;
            }
        }
        this.count += (long)len;
    }

    public void writeTo(OutputStream out) throws IOException {
        Node n = this.nodeList.first;
        while (n != null) {
            if (n != this.nodeList.last) {
                out.write(n.buf, 0, n.buf.length);
            } else {
                out.write(n.buf, 0, this.lastLen);
            }
            n = n.next;
        }
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[(int)this.count];
        int destPos = 0;
        Node n = this.nodeList.first;
        while (n != null) {
            if (n != this.nodeList.last) {
                System.arraycopy(n.buf, 0, bytes, destPos, n.buf.length);
                destPos += n.buf.length;
            } else {
                System.arraycopy(n.buf, 0, bytes, destPos, this.lastLen);
                destPos += this.lastLen;
            }
            n = n.next;
        }
        return bytes;
    }

    public int getNodeCount() {
        int count = 0;
        Node n = this.nodeList.first;
        while (n != null) {
            ++count;
            n = n.next;
        }
        return count;
    }

    public byte[] digest(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        Node n = this.nodeList.first;
        while (n != null) {
            if (n != this.nodeList.last) {
                md.update(n.buf, 0, n.buf.length);
            } else {
                md.update(n.buf, 0, this.lastLen);
            }
            n = n.next;
        }
        return md.digest();
    }

    public void iterate(NodeIterator iterator) throws IOException {
        Node n = this.nodeList.first;
        while (n != null) {
            if (n != this.nodeList.last) {
                iterator.nextNode(n.buf, n.buf.length);
            } else {
                iterator.nextNode(n.buf, this.lastLen);
            }
            n = n.next;
        }
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), 0, (int)this.count, charset);
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), 0, (int)this.count, charset);
    }

    public String toString() {
        return StringFormat.fmt("{}: size={}, blockSize={}, nodeCount={}", ObjectUtils.toHashInfo(this), this.count, this.blockSize, this.getNodeCount());
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0L;
    }

    public void reset() {
        this.nodeList.first.next = null;
        this.nodeList.last = this.nodeList.first;
        this.count = 0L;
        this.lastLen = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.blockSize);
        out.writeLong(this.count);
        out.writeInt(this.lastLen);
        out.writeInt(this.getNodeCount());
        Node n = this.nodeList.first;
        while (n != null) {
            out.writeInt(n.buf.length);
            out.write(n.buf, 0, n.buf.length);
            n = n.next;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.blockSize = in.readInt();
        this.count = in.readLong();
        this.lastLen = in.readInt();
        for (int nodeCount = in.readInt(); nodeCount > 0; --nodeCount) {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf, 0, buf.length);
            if (this.nodeList == null) {
                this.nodeList = new NodeList(buf);
                continue;
            }
            this.nodeList.insert(buf);
        }
    }

    private static class Node {
        final byte[] buf;
        Node next;

        public Node(byte[] buf) {
            this.buf = buf;
        }
    }

    private static class NodeList {
        final Node first;
        Node last;

        public NodeList(byte[] buf) {
            this.last = this.first = new Node(buf);
        }

        public void insert(byte[] buf) {
            Node n;
            this.last.next = n = new Node(buf);
            this.last = n;
        }
    }

    public static interface NodeIterator {
        public void nextNode(byte[] var1, int var2) throws IOException;
    }
}

