/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class LimitedQueue<E>
implements Queue<E>,
Iterable<E> {
    private final int size;
    private final Queue<E> queue = new LinkedList();

    public LimitedQueue(int size) {
        this.size = size;
    }

    private boolean trim() {
        boolean changed;
        boolean bl = changed = this.queue.size() > this.size;
        while (this.queue.size() > this.size) {
            this.queue.remove();
        }
        return changed;
    }

    @Override
    public boolean add(E o) {
        boolean changed = this.queue.add(o);
        boolean trimmed = this.trim();
        return changed || trimmed;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = this.queue.addAll(c);
        boolean trimmed = this.trim();
        return changed || trimmed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean offer(E e) {
        boolean changed = this.queue.offer(e);
        boolean trimmed = this.trim();
        return changed || trimmed;
    }

    @Override
    public E remove() {
        return this.queue.remove();
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }
}

