/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Out;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.SYS;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;

public class Language
extends InitializeObject {
    public static final Language EN = new Language().setLocale(Locale.US).setPatternDate("MM/dd/yyyy").setPatternYearMonth("MM/yyyy").initialize();
    public static final Language VI = new Language().setLocale(new Locale("vi", "VN")).setPatternDate("dd/MM/yyyy").setPatternYearMonth("MM/yyyy").initialize();
    private Locale locale;
    private String patternDate;
    private String patternYearMonth;
    private String patternDateTime;
    private String patternDateTimeZ;
    private String patternDateTimeM;
    private String patternDateTimeMZ;
    private static volatile Language __default;
    private static final Object MUTEX;
    private static Supplier<Language> __provider;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.locale, "locale is required.");
        AssertUtils.assertNotNull(this.patternDate, "datePattern is required.");
        AssertUtils.assertNotNull(this.patternYearMonth, "datePattern is required.");
        this.patternDateTime = String.format("%s %s", this.patternDate, "HH:mm:ss.SSS");
        this.patternDateTimeZ = String.format("%s %s", this.patternDate, "HH:mm:ss.SSSXXX");
        this.patternDateTimeM = String.format("%s %s", this.patternDate, "HH:mm");
        this.patternDateTimeMZ = String.format("%s %s", this.patternDate, "HH:mmXXX");
    }

    @Override
    public Language initialize() throws InitializeException {
        super.initialize();
        return this;
    }

    public String getId() {
        this.initialize();
        return this.locale.getLanguage();
    }

    public String getDisplayName() {
        this.initialize();
        return this.locale.getDisplayLanguage(this.locale);
    }

    public Locale getLocale() {
        this.initialize();
        return this.locale;
    }

    public Language setLocale(Locale locale) {
        this.assertNotInitialized();
        this.locale = locale;
        return this;
    }

    public String getPatternDate() {
        this.initialize();
        return this.patternDate;
    }

    public Language setPatternDate(String patternDate) {
        this.assertNotInitialized();
        this.patternDate = StringUtils.trimToNull(patternDate);
        return this;
    }

    public String getPatternYearMonth() {
        this.initialize();
        return this.patternYearMonth;
    }

    public Language setPatternYearMonth(String patternYearMonth) {
        this.assertNotInitialized();
        this.patternYearMonth = patternYearMonth;
        return this;
    }

    public String getPatternDateTime() {
        this.initialize();
        return this.patternDateTime;
    }

    public String getPatternDateTimeZ() {
        this.initialize();
        return this.patternDateTimeZ;
    }

    public String getPatternDateTimeM() {
        this.initialize();
        return this.patternDateTimeM;
    }

    public String getPatternDateTimeMZ() {
        this.initialize();
        return this.patternDateTimeMZ;
    }

    public String getPatternTimeM() {
        this.initialize();
        return "HH:mm";
    }

    public String getPatternTimeMZ() {
        this.initialize();
        return "HH:mmXXX";
    }

    public String getPatternTime() {
        this.initialize();
        return "HH:mm:ss.SSS";
    }

    public String getPatternTimeZ() {
        this.initialize();
        return "HH:mm:ss.SSSXXX";
    }

    public int hashCode() {
        return Objects.hashCode(this.getId().toLowerCase(Locale.ENGLISH));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Language)) {
            return false;
        }
        Language another = (Language)obj;
        return this.getId().equalsIgnoreCase(another.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language getDefault() {
        Language obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = Language.initLanguage();
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(Language impl) {
        if (__default == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__default == null) {
                    __default = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("Language.__default must be null.");
    }

    public static void setProvider(Supplier<Language> provider) {
        AssertUtils.assertNull(__default);
        __provider = provider;
    }

    private static Language initLanguage() {
        if (__provider != null) {
            return __provider.get();
        }
        try {
            String implName = SYS.resolveExpr("${language_impl,env.LANGUAGE_IMPL}", new Out<Boolean>());
            if (implName == null) {
                return EN;
            }
            Class implClass = ReflectionUtils.loadClass(implName, null);
            return (Language)ReflectionUtils.newInstance(implClass);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

