/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeSupport;
import com.appslandia.common.json.JsonIgnore;

public abstract class InitializeObject
implements InitializeSupport {
    private volatile boolean initialized = false;
    @JsonIgnore
    private final Object initMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitializeObject initialize() throws InitializeException {
        if (this.initialized) {
            return this;
        }
        Object object = this.initMutex;
        synchronized (object) {
            if (this.initialized) {
                return this;
            }
            try {
                this.init();
                this.initialized = true;
            }
            catch (Exception ex) {
                throw new InitializeException(ex);
            }
        }
        return this;
    }

    protected abstract void init() throws Exception;

    @Override
    public void destroy() throws DestroyException {
    }

    protected void assertNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("initialized.");
        }
    }
}

