/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupFormat {
    private static final Pattern GROUP_SIZE_PATTERN = Pattern.compile("\\{\\s*\\d+\\s*}");
    final String format;
    private Group[] groups;
    private int inputLength;
    private int outputLength;

    public GroupFormat(String format) {
        this.format = AssertUtils.assertNotNull(format, "format is required.");
        this.parseFormat(format);
    }

    private void parseFormat(String format) {
        Matcher matcher = GROUP_SIZE_PATTERN.matcher(format);
        ArrayList<Group> list = new ArrayList<Group>();
        int inputLength = 0;
        int outputLength = 0;
        int lastEnd = 0;
        while (matcher.find()) {
            String sizeGroup;
            int size;
            String text;
            int start = matcher.start();
            if (start > 0 && !(text = format.substring(lastEnd, start)).isEmpty()) {
                list.add(new Group(text, 0));
                outputLength += text.length();
            }
            if ((size = Integer.parseInt((sizeGroup = matcher.group()).substring(1, sizeGroup.length() - 1).trim())) == 0) {
                throw new IllegalArgumentException("format is invalid (format=" + format + ")");
            }
            inputLength += size;
            outputLength += size;
            list.add(new Group(null, size));
            lastEnd = matcher.end();
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No group found (format=" + format + ")");
        }
        this.groups = list.toArray(new Group[list.size()]);
        this.inputLength = inputLength;
        this.outputLength = outputLength;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public String format(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() != this.inputLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(this.outputLength);
        int pos = 0;
        for (Group group : this.groups) {
            if (group.length > 0) {
                sb.append(str.substring(pos, group.length + pos));
                pos += group.length;
                continue;
            }
            sb.append(group.text);
        }
        return sb.toString();
    }

    private static class Group {
        final String text;
        final int length;

        public Group(String text, int length) {
            this.text = text;
            this.length = length;
        }
    }
}

