/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.Language;
import com.appslandia.common.base.ProviderMap;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class FormatProviderImpl
implements FormatProvider {
    protected final Language language;
    protected NumberFormat integerFormat;
    protected NumberFormat decimalFormat;
    protected ProviderMap<String, SimpleDateFormat> dateFormats;
    protected ProviderMap<Locale, NumberFormat> currencyFormats;

    public FormatProviderImpl() {
        this(Language.getDefault());
    }

    public FormatProviderImpl(Language language) {
        this.language = language;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public NumberFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = NumberFormat.getIntegerInstance(this.language.getLocale());
        }
        return this.integerFormat;
    }

    @Override
    public NumberFormat getDecimalFormat() {
        if (this.decimalFormat == null) {
            NumberFormat impl = NumberFormat.getNumberInstance(this.language.getLocale());
            if (impl instanceof DecimalFormat) {
                ((DecimalFormat)impl).setParseBigDecimal(true);
            }
            this.decimalFormat = impl;
        }
        return this.decimalFormat;
    }

    @Override
    public DateFormat getDateFormat(String pattern) {
        return this.getDateFormats().get(pattern);
    }

    protected ProviderMap<String, SimpleDateFormat> getDateFormats() {
        if (this.dateFormats != null) {
            return this.dateFormats;
        }
        this.dateFormats = new ProviderMap<String, SimpleDateFormat>(pattern -> {
            SimpleDateFormat value = new SimpleDateFormat((String)pattern);
            value.setLenient(false);
            return value;
        });
        return this.dateFormats;
    }

    @Override
    public NumberFormat getCurrencyFormat(Locale locale) {
        return this.getCurrencyFormats().get(locale);
    }

    protected ProviderMap<Locale, NumberFormat> getCurrencyFormats() {
        if (this.currencyFormats != null) {
            return this.currencyFormats;
        }
        this.currencyFormats = new ProviderMap<Locale, NumberFormat>(locale -> {
            NumberFormat value = NumberFormat.getCurrencyInstance(locale);
            if (value instanceof DecimalFormat) {
                ((DecimalFormat)value).setParseBigDecimal(true);
            }
            return value;
        });
        return this.currencyFormats;
    }
}

