/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;

public class FluentList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<E> list;

    public FluentList() {
        this(new ArrayList());
    }

    public FluentList(List<E> list) {
        this.list = list;
    }

    public FluentList<E> first(E e) {
        this.list.add(0, e);
        return this;
    }

    public FluentList<E> last(E e) {
        this.list.add(e);
        return this;
    }

    public FluentList<E> ins(E e) {
        this.list.add(e);
        return this;
    }

    public FluentList<E> ins(int index, E e) {
        this.list.add(index, e);
        return this;
    }

    public FluentList<E> ins(int index, Collection<? extends E> c) {
        this.list.addAll(index, c);
        return this;
    }

    public FluentList<E> ins(Collection<? extends E> c) {
        this.list.addAll(c);
        return this;
    }

    public E first() {
        this.assertNotEmpty();
        return this.list.get(0);
    }

    public E last() {
        this.assertNotEmpty();
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public FluentList<E> removeFirst() {
        this.assertNotEmpty();
        this.list.remove(0);
        return this;
    }

    @Override
    public FluentList<E> removeLast() {
        this.assertNotEmpty();
        this.list.remove(this.list.size() - 1);
        return this;
    }

    void assertNotEmpty() {
        if (this.list.isEmpty()) {
            throw new NoSuchElementException("The list is empty.");
        }
    }

    @Override
    public boolean add(E e) {
        return this.list.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.list.replaceAll(operator);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.list.sort(c);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

