/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.Out;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.SYS;
import java.util.Locale;

public class DeployEnv {
    public static final DeployEnv DEVELOPMENT = new DeployEnv("Development");
    public static final DeployEnv TESTING = new DeployEnv("Testing");
    public static final DeployEnv STAGING = new DeployEnv("Staging");
    public static final DeployEnv PRODUCTION = new DeployEnv("Production");
    final String name;
    private static volatile DeployEnv __current;
    private static final Object MUTEX;

    private DeployEnv(String name) {
        this.name = AssertUtils.assertNotNull(name);
    }

    public boolean isStagingOrProduction() {
        return this.equals(STAGING) || this.equals(PRODUCTION);
    }

    public boolean isDevelopment() {
        return this.equals(DEVELOPMENT) || this.name.toLowerCase(Locale.ENGLISH).startsWith("development");
    }

    public boolean isTesting() {
        return this.equals(TESTING);
    }

    public boolean isStaging() {
        return this.equals(STAGING);
    }

    public boolean isProduction() {
        return this.equals(PRODUCTION);
    }

    public boolean isAny(String ... environments) {
        for (String env : environments) {
            if (!this.name.equalsIgnoreCase(env)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DeployEnv: " + this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeployEnv)) {
            return false;
        }
        DeployEnv another = (DeployEnv)obj;
        return this.name.equalsIgnoreCase(another.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployEnv getCurrent() {
        DeployEnv obj = __current;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __current;
                if (obj == null) {
                    __current = obj = DeployEnv.initDeployEnv();
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrent(DeployEnv env) {
        if (__current == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__current == null) {
                    __current = env;
                    return;
                }
            }
        }
        throw new IllegalStateException("DeployEnv.__current must be null.");
    }

    public static void setCurrent(String env) {
        DeployEnv.setCurrent(DeployEnv.getDeployEnv(env));
    }

    private static DeployEnv initDeployEnv() {
        String env = SYS.resolveExpr("${deploy_env,env.DEPLOY_ENV:Development}", new Out<Boolean>());
        return DeployEnv.getDeployEnv(env);
    }

    private static DeployEnv getDeployEnv(String env) {
        if (DeployEnv.DEVELOPMENT.name.equalsIgnoreCase(env)) {
            return DEVELOPMENT;
        }
        if (DeployEnv.TESTING.name.equalsIgnoreCase(env)) {
            return TESTING;
        }
        if (DeployEnv.STAGING.name.equalsIgnoreCase(env)) {
            return STAGING;
        }
        if (DeployEnv.PRODUCTION.name.equalsIgnoreCase(env)) {
            return PRODUCTION;
        }
        return new DeployEnv(env);
    }

    static {
        MUTEX = new Object();
    }
}

