/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BoolFormatException;
import com.appslandia.common.base.Out;
import com.appslandia.common.utils.ParseUtils;
import com.appslandia.common.utils.SYS;
import com.appslandia.common.utils.SplitUtils;
import com.appslandia.common.utils.StringFormat;
import com.appslandia.common.utils.StringUtils;
import java.util.Map;

public interface Config {
    public String getString(String var1);

    default public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value != null ? value : defaultValue;
    }

    default public String getRequiredString(String key) throws IllegalStateException {
        String value = this.getString(key);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        return value;
    }

    default public String[] getStringArray(String key) {
        String value = this.getString(key);
        if (value == null) {
            return StringUtils.EMPTY_ARRAY;
        }
        return SplitUtils.split(value, ',');
    }

    default public String getFormatted(String key) throws IllegalStateException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return StringFormat.format(value, (pname, expr) -> {
            String resolvedValue = this.getString((String)pname);
            if (resolvedValue == null) {
                resolvedValue = SYS.resolveExpr(expr, new Out<Boolean>());
            }
            if (resolvedValue == null) {
                throw SYS.toNoValueExprException(expr);
            }
            return resolvedValue;
        });
    }

    default public String getRequiredFormatted(String key) throws IllegalStateException {
        String value = this.getFormatted(key);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        return value;
    }

    default public String getFormatted(String key, Map<String, Object> parameters) throws IllegalStateException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return StringFormat.format(value, (pname, expr) -> {
            Object resolvedValue = parameters.get(pname);
            if (resolvedValue == null) {
                resolvedValue = this.getString((String)pname);
            }
            if (resolvedValue == null) {
                resolvedValue = SYS.resolveExpr(expr, new Out<Boolean>());
            }
            if (resolvedValue == null) {
                throw SYS.toNoValueExprException(expr);
            }
            return resolvedValue;
        });
    }

    default public String getRequiredFormatted(String key, Map<String, Object> parameters) throws IllegalStateException {
        String value = this.getFormatted(key, parameters);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        return value;
    }

    default public String getFormatted(String key, Object ... parameters) throws IllegalStateException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return StringFormat.format(value, (pname, expr) -> {
            Object resolvedValue = null;
            try {
                int index = Integer.parseInt(pname);
                if (0 <= index && index < parameters.length) {
                    resolvedValue = parameters[index];
                }
            }
            catch (NumberFormatException ex) {
                resolvedValue = SYS.resolveExpr(expr, new Out<Boolean>());
            }
            if (resolvedValue == null) {
                throw SYS.toNoValueExprException(expr);
            }
            return resolvedValue;
        });
    }

    default public String getRequiredFormatted(String key, Object ... parameters) throws IllegalStateException {
        String value = this.getFormatted(key, parameters);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        return value;
    }

    default public boolean getBool(String key, boolean defaultValue) {
        String value = this.getString(key);
        return ParseUtils.parseBool(value, defaultValue);
    }

    default public boolean getRequiredBool(String key) throws IllegalStateException, BoolFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        if (ParseUtils.isTrueValue(value)) {
            return true;
        }
        if (ParseUtils.isFalseValue(value)) {
            return false;
        }
        throw new BoolFormatException(value);
    }

    default public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return ParseUtils.parseInt(value, defaultValue);
    }

    default public int getRequiredInt(String key) throws IllegalStateException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        return Integer.parseInt(value);
    }

    default public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return ParseUtils.parseLong(value, defaultValue);
    }

    default public long getRequiredLong(String key) throws IllegalStateException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        return Long.parseLong(value);
    }

    default public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return ParseUtils.parseDouble(value, defaultValue);
    }

    default public double getRequiredDouble(String key) throws IllegalStateException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw Config.toNoValueException(key);
        }
        double val = Double.parseDouble(value);
        if (Double.isNaN(val)) {
            throw Config.toNoValueException(key);
        }
        return val;
    }

    public static IllegalStateException toNoValueException(String key) {
        return new IllegalStateException("The key '" + key + "' doesn't have a value.");
    }
}

