/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import com.appslandia.common.validators.ModelValidator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface Validate {
    public String message();

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String modelValidator();

    public String reportProperty();

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<Validate, Object> {
        private String message;
        private String reportProperty;
        private String validator;

        public void initialize(Validate annotation) {
            this.message = annotation.message();
            this.reportProperty = annotation.reportProperty();
            this.validator = annotation.modelValidator();
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            boolean isValid = ModelValidator.getValidator(this.validator).validate(value);
            if (!isValid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(this.reportProperty).addConstraintViolation();
            }
            return isValid;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public Validate[] value();
    }
}

