/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface DigitOnly {
    public static final Pattern DIGITS_PATTERN = Pattern.compile("\\d+");

    public String message() default "{com.appslandia.common.validators.DigitOnly.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public int value() default 0;

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<DigitOnly, CharSequence> {
        private int length;

        public void initialize(DigitOnly annotation) {
            this.length = annotation.value();
        }

        public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            if (this.length > 0 && value.length() != this.length) {
                return false;
            }
            return DIGITS_PATTERN.matcher(value).matches();
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public DigitOnly[] value();
    }
}

