/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.CollectionUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormatUtils {
    private static final Pattern NAMED_PARAMS_PATTERN = Pattern.compile("\\{[^}]+?}");
    private static final Pattern INDEX_PARAMS_PATTERN = Pattern.compile("\\{\\d+}");

    public static String format(String str, Map<String, Object> namedParameters) {
        Matcher matcher = NAMED_PARAMS_PATTERN.matcher(str);
        StringBuilder sb = new StringBuilder(str.length() + namedParameters.size() * 10);
        int prevEnd = 0;
        while (matcher.find()) {
            if (prevEnd == 0) {
                sb.append(str.substring(0, matcher.start()));
            } else {
                sb.append(str.substring(prevEnd, matcher.start()));
            }
            String parameterGroup = matcher.group();
            String parameterName = parameterGroup.substring(1, parameterGroup.length() - 1);
            StringFormatUtils.appendParam(sb, namedParameters.get(parameterName), parameterGroup);
            prevEnd = matcher.end();
        }
        if (prevEnd < str.length()) {
            sb.append(str.substring(prevEnd));
        }
        return sb.toString();
    }

    public static String format(String str, Object ... parameters) {
        Matcher matcher = INDEX_PARAMS_PATTERN.matcher(str);
        StringBuilder sb = new StringBuilder(str.length() + parameters.length * 10);
        int prevEnd = 0;
        while (matcher.find()) {
            if (prevEnd == 0) {
                sb.append(str.substring(0, matcher.start()));
            } else {
                sb.append(str.substring(prevEnd, matcher.start()));
            }
            String parameterGroup = matcher.group();
            String parameterIndex = parameterGroup.substring(1, parameterGroup.length() - 1);
            int index = -1;
            try {
                index = Integer.parseInt(parameterIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (0 <= index && index <= parameters.length - 1) {
                StringFormatUtils.appendParam(sb, parameters[index], parameterGroup);
            } else {
                sb.append(parameterGroup);
            }
            prevEnd = matcher.end();
        }
        if (prevEnd < str.length()) {
            sb.append(str.substring(prevEnd));
        }
        return sb.toString();
    }

    private static void appendParam(StringBuilder sb, Object param, String parameterGroup) {
        if (param != null) {
            if (param.getClass().isArray()) {
                sb.append(CollectionUtils.toElements(param));
            } else {
                sb.append(param.toString());
            }
        } else {
            sb.append(parameterGroup);
        }
    }
}

