/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.ConfigMap;
import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.FormatProviderImpl;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.FormatterProvider;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;

public class PropertyUtils {
    public static final PropertyStrategy METHOD_PROPERTY_STRATEGY = new PropertyStrategy(){

        @Override
        public Method find(Class<?> clazz, final String propertyName) {
            return ReflectionUtils.traverse(clazz, new ReflectionUtils.MethodHandler(){

                @Override
                public boolean matches(Method m) {
                    if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) {
                        return false;
                    }
                    if (m.getParameterCount() != 1) {
                        return false;
                    }
                    return m.getName().equals(propertyName);
                }

                @Override
                public boolean handle(Method m) throws ReflectionException {
                    return false;
                }
            });
        }
    };
    public static final PropertyStrategy BEAN_PROPERTY_STRATEGY = new PropertyStrategy(){

        @Override
        public Method find(Class<?> clazz, final String propertyName) {
            return ReflectionUtils.traverse(clazz, new ReflectionUtils.MethodHandler(){

                @Override
                public boolean matches(Method m) {
                    if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) {
                        return false;
                    }
                    if (m.getParameterCount() != 1) {
                        return false;
                    }
                    return m.getName().equals("set" + StringUtils.firstUpperCase(propertyName, Locale.ENGLISH));
                }

                @Override
                public boolean handle(Method m) throws ReflectionException {
                    return false;
                }
            });
        }
    };

    public static void initialize(Object obj, ConfigMap config, PropertyStrategy propertyStrategy) throws FormatterException, ReflectionException {
        PropertyUtils.initialize(obj, config, new FormatProviderImpl(), propertyStrategy);
    }

    public static void initialize(Object obj, ConfigMap config, FormatProvider formatProvider, PropertyStrategy propertyStrategy) throws FormatterException, ReflectionException {
        for (String property : config.keySet()) {
            Method m = propertyStrategy.find(obj.getClass(), property);
            if (m == null) continue;
            Class<?> parameterType = m.getParameterTypes()[0];
            Formatter formatter = FormatterProvider.getDefault().findFormatter((String)null, parameterType);
            if (formatter == null) continue;
            Object value = formatter.parse(config.getString(property), formatProvider);
            ReflectionUtils.invoke(m, obj, value);
        }
    }

    private static interface PropertyStrategy {
        public Method find(Class<?> var1, String var2);
    }
}

