/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.PatternUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class PatternValidator
extends InitializeObject {
    private List<Pattern> allowPatterns = new ArrayList<Pattern>();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertHasElements(this.allowPatterns, "allowPatterns is required.");
        this.allowPatterns = Collections.unmodifiableList(this.allowPatterns);
    }

    public PatternValidator allowPatterns(String ... patterns) {
        this.assertNotInitialized();
        CollectionUtils.toList(this.allowPatterns, PatternUtils.compile(patterns));
        return this;
    }

    public PatternValidator allowPatterns(Pattern ... patterns) {
        this.assertNotInitialized();
        CollectionUtils.toList(this.allowPatterns, patterns);
        return this;
    }

    public boolean validate(String value) {
        this.initialize();
        AssertUtils.assertNotNull(value);
        return PatternUtils.matches(this.allowPatterns, value);
    }
}

