/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ExceptionUtils;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ObjectInvoker {
    final Object obj;

    public ObjectInvoker(Object obj) {
        this.obj = AssertUtils.assertNotNull(obj);
    }

    protected Object invokeMethod(String method, Class<?>[] parameterTypes, Object[] args) throws Exception {
        try {
            Method m = this.obj.getClass().getMethod(method, parameterTypes);
            return m.invoke(this.obj, args);
        }
        catch (InvocationTargetException ex) {
            throw ExceptionUtils.tryUnwrap(ex);
        }
    }

    public ObjectInvoker invoke(String method) throws Exception {
        this.invokeMethod(method, ReflectionUtils.EMPTY_CLASSES, ReflectionUtils.EMPTY_OBJECTS);
        return this;
    }

    public ObjectInvoker invoke(String method, Class<?> parameterType, Object arg) throws Exception {
        this.invokeMethod(method, new Class[]{parameterType}, new Object[]{arg});
        return this;
    }

    public ObjectInvoker invoke(String method, Class<?>[] parameterTypes, Object[] args) throws Exception {
        this.invokeMethod(method, parameterTypes, args);
        return this;
    }

    public Object invokeResult(String method) throws Exception {
        return this.invokeMethod(method, ReflectionUtils.EMPTY_CLASSES, ReflectionUtils.EMPTY_OBJECTS);
    }

    public Object invokeResult(String method, Class<?> parameterType, Object arg) throws Exception {
        return this.invokeMethod(method, new Class[]{parameterType}, new Object[]{arg});
    }

    public Object invokeResult(String method, Class<?>[] parameterTypes, Object[] args) throws Exception {
        return this.invokeMethod(method, parameterTypes, args);
    }
}

