/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.PatternUtils;
import com.appslandia.common.utils.StringUtils;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class NormalizeUtils {
    private static DecomposedCharacterConverter decomposedCharacterConverter;
    private static final Pattern STRIP_ACCENTS_PATTERN;
    private static final Pattern[] WTSPACE_PUNCT_DBLHYPHEN_PATTERNS;
    private static final Pattern[] WTSPACE_PATTERNS;

    public static void setDecomposedCharacterConverter(DecomposedCharacterConverter converter) {
        AssertUtils.assertNull(decomposedCharacterConverter);
        decomposedCharacterConverter = converter;
    }

    public static String unaccent(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder decomposed = new StringBuilder(Normalizer.normalize(text, Normalizer.Form.NFD));
        if (decomposedCharacterConverter != null) {
            for (int i = 0; i < decomposed.length(); ++i) {
                char converted = decomposedCharacterConverter.convert(decomposed.charAt(i));
                if (converted == decomposed.charAt(i)) continue;
                decomposed.deleteCharAt(i);
                decomposed.insert(i, converted);
            }
        }
        return STRIP_ACCENTS_PATTERN.matcher(decomposed).replaceAll("");
    }

    public static String normalizeLabel(String label) {
        return NormalizeUtils.normalize(label, WTSPACE_PUNCT_DBLHYPHEN_PATTERNS, '-');
    }

    public static String normalizeSingleLine(String str) {
        return NormalizeUtils.normalize(str, WTSPACE_PATTERNS, ' ');
    }

    public static String normalize(String str, Pattern[] matchers, char bySep) {
        if (str == null) {
            return null;
        }
        String replacement = new String(new char[]{bySep});
        for (Pattern p : matchers) {
            str = p.matcher(str).replaceAll(replacement);
        }
        return StringUtils.trimToNull(str, bySep);
    }

    static {
        STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        WTSPACE_PUNCT_DBLHYPHEN_PATTERNS = PatternUtils.compile("\\s+|\\p{Punct}+", "-{2,}");
        WTSPACE_PATTERNS = PatternUtils.compile("\\s+");
    }

    public static interface DecomposedCharacterConverter {
        public char convert(char var1);
    }
}

