/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;

public class EmailUtils {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?=.{3,128}$)[_a-z\\d-\\+]+(\\.[_a-z\\d-]+)*@[a-z\\d-]+(\\.[a-z\\d-]+)*(\\.[a-z]{2,})", 2);

    public static boolean isValid(CharSequence email) {
        if (email == null) {
            return true;
        }
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public static InternetAddress parseAddress(String email, String person) {
        try {
            return new InternetAddress(email, person, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }
}

