/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.DateFormatException;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss.SSS";
    public static final String PATTERN_TIME_Z = "HH:mm:ss.SSSXXX";
    public static final String PATTERN_TIME_MI = "HH:mm";
    public static final String PATTERN_TIME_MIZ = "HH:mmXXX";
    public static final String PATTERN_DATETIME = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String PATTERN_DATETIME_Z = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String PATTERN_DATETIME_MI = "yyyy-MM-dd'T'HH:mm";
    public static final String PATTERN_DATETIME_MIZ = "yyyy-MM-dd'T'HH:mmXXX";
    private static final Pattern TEMPORAL_AMT_PATTERN = Pattern.compile("((\\d+.\\d+|\\d+)(wk|d|hr|min|sec|ms)\\s*)+", 2);

    public static long translateToMs(String temporalAmt) throws IllegalArgumentException {
        temporalAmt = StringUtils.trimToNull(temporalAmt);
        AssertUtils.assertNotNull(temporalAmt, "temporalAmt is required.");
        AssertUtils.assertTrue(TEMPORAL_AMT_PATTERN.matcher(temporalAmt).matches(), "temporalAmt is invalid format.");
        double result = 0.0;
        int i = 0;
        while (i < temporalAmt.length()) {
            int k;
            int j = i;
            while (Character.isDigit(temporalAmt.charAt(j))) {
                ++j;
            }
            for (k = j; k <= temporalAmt.length() - 1 && (Character.isLetter(temporalAmt.charAt(k)) || temporalAmt.charAt(k) == ' '); ++k) {
            }
            double amt = Double.parseDouble(temporalAmt.substring(i, j));
            String unit = temporalAmt.substring(j, k).trim();
            result = "wk".equalsIgnoreCase(unit) ? (result += (double)(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS) * 7L) * amt) : ("d".equalsIgnoreCase(unit) ? (result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS) * amt) : ("hr".equalsIgnoreCase(unit) ? (result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS) * amt) : ("min".equalsIgnoreCase(unit) ? (result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES) * amt) : ("sec".equalsIgnoreCase(unit) ? (result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS) * amt) : (result += amt)))));
            i = k;
        }
        return (long)Math.ceil(result);
    }

    public static Map<TimeUnit, Long> parseUnits(long durationMs, TimeUnit start, TimeUnit end) {
        return DateUtils.parseUnits(durationMs, TimeUnit.MILLISECONDS, start, end);
    }

    public static Map<TimeUnit, Long> parseUnits(long duration, TimeUnit unit, TimeUnit start, TimeUnit end) {
        AssertUtils.assertTrue(start.compareTo(end) >= 0);
        EnumMap<TimeUnit, Long> map = new EnumMap<TimeUnit, Long>(TimeUnit.class);
        long ms = TimeUnit.MILLISECONDS.convert(duration, unit);
        TimeUnit u = start;
        while (true) {
            long v = u.convert(ms, TimeUnit.MILLISECONDS);
            map.put(u, v);
            if (u == end) break;
            ms -= TimeUnit.MILLISECONDS.convert(v, u);
            u = DateUtils.nextUnit(u);
        }
        return map;
    }

    private static TimeUnit nextUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return TimeUnit.HOURS;
            }
            case HOURS: {
                return TimeUnit.MINUTES;
            }
            case MINUTES: {
                return TimeUnit.SECONDS;
            }
            case SECONDS: {
                return TimeUnit.MILLISECONDS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isFutureTime(long timeMillis, int leewayMs) {
        AssertUtils.assertTrue(leewayMs >= 0);
        return System.currentTimeMillis() - (long)leewayMs < timeMillis;
    }

    public static boolean isPastTime(long timeMillis, int leewayMs) {
        AssertUtils.assertTrue(leewayMs >= 0);
        return System.currentTimeMillis() + (long)leewayMs >= timeMillis;
    }

    public static java.sql.Date today() {
        return new java.sql.Date(DateUtils.todayCalendar().getTimeInMillis());
    }

    public static long todayAsLong() {
        return DateUtils.todayCalendar().getTimeInMillis();
    }

    public static Calendar todayCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        DateUtils.clearTime(cal);
        return cal;
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static long nowAsLong() {
        return System.currentTimeMillis();
    }

    public static Timestamp nowNoMs() {
        return new Timestamp(DateUtils.clearMs(System.currentTimeMillis()));
    }

    public static long nowNoMsAsLong() {
        return DateUtils.clearMs(System.currentTimeMillis());
    }

    public static long clearMs(long timeInMs) {
        return timeInMs / 1000L * 1000L;
    }

    public static Date clearMs(Date dt) {
        return new Date(DateUtils.clearMs(dt.getTime()));
    }

    public static long clearTime(long timeInMs) {
        return DateUtils.clearTime(new Date(timeInMs)).getTime();
    }

    public static Date clearTime(Date dt) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        DateUtils.clearTime(cal);
        return cal.getTime();
    }

    public static void clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static Calendar getCalendar(int dayOfWeek, int atHour, int atMinute) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(7, dayOfWeek);
        cal.set(11, atHour);
        cal.set(12, atMinute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date copyTime(Date dest, Date src) {
        GregorianCalendar destCal = new GregorianCalendar();
        destCal.setTime(dest);
        GregorianCalendar srcCal = new GregorianCalendar();
        srcCal.setTime(src);
        destCal.set(11, srcCal.get(11));
        destCal.set(12, srcCal.get(12));
        destCal.set(13, srcCal.get(13));
        destCal.set(14, srcCal.get(14));
        return destCal.getTime();
    }

    public static String format(Date dt, String pattern) {
        return DateUtils.newDateFormat(pattern).format(dt);
    }

    public static SimpleDateFormat newDateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return sdf;
    }

    public static java.sql.Date iso8601Date(String date) throws DateFormatException {
        return date != null ? new java.sql.Date(DateUtils.parse(date, PATTERN_DATE).getTime()) : null;
    }

    public static String iso8601Date(Date date) {
        return date != null ? DateUtils.newDateFormat(PATTERN_DATE).format(date) : null;
    }

    public static Time iso8601Time(String time) throws DateFormatException {
        return time != null ? new Time(DateUtils.parse(time, PATTERN_TIME).getTime()) : null;
    }

    public static String iso8601Time(Date time) {
        return time != null ? DateUtils.newDateFormat(PATTERN_TIME).format(time) : null;
    }

    public static Timestamp iso8601DateTime(String dateTime) throws DateFormatException {
        return dateTime != null ? new Timestamp(DateUtils.parse(dateTime, PATTERN_DATETIME).getTime()) : null;
    }

    public static String iso8601DateTime(Date dateTime) {
        return dateTime != null ? DateUtils.newDateFormat(PATTERN_DATETIME).format(dateTime) : null;
    }

    public static Date parse(String dt, String pattern) throws DateFormatException {
        try {
            return DateUtils.newDateFormat(pattern).parse(dt);
        }
        catch (ParseException ex) {
            throw new DateFormatException(ex);
        }
    }
}

