/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.Config;
import com.appslandia.common.base.ConfigMap;
import com.appslandia.common.base.ConfigWrapper;
import com.appslandia.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLIUtils {
    private static final String ARG_ENTRY = "--[a-z][a-z\\d]*(=[^\\s]+)?";
    private static final Pattern ARG_ENTRY_PATTERN = Pattern.compile("--[a-z][a-z\\d]*(=[^\\s]+)?", 2);
    private static final Pattern ARG_ENTRIES_PATTERN = Pattern.compile(String.format("%s(\\s+%s)*", "--[a-z][a-z\\d]*(=[^\\s]+)?", "--[a-z][a-z\\d]*(=[^\\s]+)?"), 2);

    public static Config parseArgs(String[] args) throws IllegalArgumentException {
        ConfigMap argMap = new ConfigMap();
        for (String arg : args) {
            if (ARG_ENTRY_PATTERN.matcher(arg).matches()) {
                int idx = arg.indexOf(61);
                if (idx < 0) {
                    argMap.put(arg.substring(2), String.valueOf(true));
                    continue;
                }
                argMap.put(arg.substring(2, idx), arg.substring(idx + 1));
                continue;
            }
            throw new IllegalArgumentException("arg=" + arg);
        }
        return new ConfigWrapper(argMap);
    }

    public static Config parseArgs(String args) {
        if ((args = StringUtils.trimToNull(args)) == null) {
            return new ConfigWrapper(new ConfigMap());
        }
        if (!ARG_ENTRIES_PATTERN.matcher(args).matches()) {
            throw new IllegalArgumentException("args is invalid (value=" + args + ")");
        }
        Matcher matcher = ARG_ENTRY_PATTERN.matcher(args);
        ArrayList<String> argList = new ArrayList<String>();
        while (matcher.find()) {
            argList.add(matcher.group());
        }
        return CLIUtils.parseArgs(argList.toArray(new String[argList.size()]));
    }
}

