/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.regex.Pattern;

public class BytesSizeUtils {
    private static final Pattern BYTES_SIZE_PATTERN = Pattern.compile("((\\d+.\\d+|\\d+)(TB|GB|MB|KB|B)\\s*)+", 2);

    public static long translateToBytes(String sizeAmt) throws IllegalArgumentException {
        sizeAmt = StringUtils.trimToNull(sizeAmt);
        AssertUtils.assertNotNull(sizeAmt, "sizeAmt is required.");
        AssertUtils.assertTrue(BYTES_SIZE_PATTERN.matcher(sizeAmt).matches(), "sizeAmt is invalid format.");
        double result = 0.0;
        int i = 0;
        while (i < sizeAmt.length()) {
            int k;
            int j = i;
            while (Character.isDigit(sizeAmt.charAt(j)) || sizeAmt.charAt(j) == '.') {
                ++j;
            }
            for (k = j; k <= sizeAmt.length() - 1 && (Character.isLetter(sizeAmt.charAt(k)) || sizeAmt.charAt(k) == ' '); ++k) {
            }
            double amt = Double.parseDouble(sizeAmt.substring(i, j));
            String unit = sizeAmt.substring(j, k).trim();
            result = "GB".equalsIgnoreCase(unit) ? (result += 1.0E9 * amt) : ("MB".equalsIgnoreCase(unit) ? (result += 1000000.0 * amt) : ("KB".equalsIgnoreCase(unit) ? (result += 1000.0 * amt) : (result += amt)));
            i = k;
        }
        return (long)Math.ceil(result);
    }
}

