/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.objects.ObjectException;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.reflect.Method;
import javax.annotation.PreDestroy;

public class ObjectFactoryUtils {
    public static void destroy(final Object obj) throws ObjectException {
        AssertUtils.assertNotNull(obj);
        ReflectionUtils.traverse(obj.getClass(), new ReflectionUtils.MethodHandler(){

            @Override
            public boolean matches(Method m) {
                return m.getDeclaredAnnotation(PreDestroy.class) != null;
            }

            @Override
            public boolean handle(Method m) throws ReflectionException {
                try {
                    m.setAccessible(true);
                    m.invoke(obj, new Object[0]);
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
                return false;
            }
        });
    }
}

