/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.mail;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.SecureProps;
import com.appslandia.common.mail.MailMessage;
import com.appslandia.common.threading.ThreadTask;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class SmtpMailer
extends InitializeObject {
    protected SecureProps props;
    protected Session session;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.props, "props is required.");
        this.session = Session.getInstance((Properties)this.props);
    }

    public void send(MailMessage message) throws MessagingException {
        this.send(CollectionUtils.toList(new ArrayList(1), new MailMessage[]{message}));
    }

    public void send(List<MailMessage> messages) throws MessagingException {
        this.initialize();
        AssertUtils.assertNotNull(messages);
        try (Transport transport = this.session.getTransport("smtp");){
            String user = AssertUtils.assertNotNull(this.props.get("mail.smtp.user"), "mail.smtp.user is required.");
            String password = AssertUtils.assertNotNull(this.props.get("mail.smtp.password"), "mail.smtp.password is required.");
            transport.connect(user, password);
            for (MailMessage mailMessage : messages) {
                MimeMessage message = mailMessage.toMimeMessage(this);
                message.saveChanges();
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
        }
    }

    public void sendAsync(MailMessage message, Executor executor) {
        this.sendAsync(CollectionUtils.toList(new ArrayList(1), new MailMessage[]{message}), executor);
    }

    public void sendAsync(final List<MailMessage> messages, Executor executor) {
        this.initialize();
        AssertUtils.assertNotNull(messages);
        AssertUtils.assertNotNull(executor);
        executor.execute(new ThreadTask(){

            @Override
            protected void doRun() throws Exception {
                SmtpMailer.this.send(messages);
            }
        });
    }

    public SmtpMailer setProps(SecureProps props) {
        this.assertNotInitialized();
        if (props != null) {
            this.props = props.copy();
        }
        return this;
    }
}

