/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.mail;

import com.appslandia.common.mail.SmtpMailer;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.EmailUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailMessage {
    private Address sender;
    private List<Address> from;
    private List<Address> replyTo;
    private List<Address> to;
    private List<Address> cc;
    private List<Address> bcc;
    private String subject;
    private Object content;
    private String contentType;
    private Date sentDate;
    private Consumer<MimeMessage> msgInit;

    public MailMessage sender(String email) throws AddressException {
        this.sender = new InternetAddress(email);
        return this;
    }

    public MailMessage sender(String email, String person) {
        this.sender = EmailUtils.parseAddress(email, person);
        return this;
    }

    public MailMessage from(String email) throws AddressException {
        this.getFrom().add((Address)new InternetAddress(email));
        return this;
    }

    public MailMessage from(String email, String person) {
        this.getFrom().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailMessage replyTo(String email) throws AddressException {
        this.getReplyTo().add((Address)new InternetAddress(email));
        return this;
    }

    public MailMessage replyTo(String email, String person) {
        this.getReplyTo().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailMessage to(String email) throws AddressException {
        this.getTo().add((Address)new InternetAddress(email));
        return this;
    }

    public MailMessage to(String email, String person) {
        this.getTo().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailMessage cc(String email) throws AddressException {
        this.getCc().add((Address)new InternetAddress(email));
        return this;
    }

    public MailMessage cc(String email, String person) {
        this.getCc().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailMessage bcc(String email) throws AddressException {
        this.getBcc().add((Address)new InternetAddress(email));
        return this;
    }

    public MailMessage bcc(String email, String person) {
        this.getBcc().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailMessage subject(String subject) {
        this.subject = subject;
        return this;
    }

    public MailMessage content(Multipart content) {
        this.content = AssertUtils.assertNotNull(content);
        return this;
    }

    public MailMessage content(Object content, String type) {
        this.content = AssertUtils.assertNotNull(content);
        this.contentType = AssertUtils.assertNotNull(type);
        return this;
    }

    public MailMessage htmlContent(String content) {
        return this.content(content, "text/html;charset=utf-8");
    }

    public MailMessage textContent(String content) {
        return this.content(content, "text/plain;charset=utf-8");
    }

    public MailMessage sentDate(Date sentDate) {
        this.sentDate = sentDate;
        return this;
    }

    public MailMessage msgInit(Consumer<MimeMessage> msgInit) {
        this.msgInit = msgInit;
        return this;
    }

    public void send(SmtpMailer mailer) throws MessagingException {
        mailer.send(this);
    }

    public MimeMessage toMimeMessage(SmtpMailer mailer) throws MessagingException {
        MimeMessage msg = new MimeMessage(mailer.session);
        msg.setSender(this.sender);
        if (this.from != null) {
            msg.addFrom(this.from.toArray(new Address[this.from.size()]));
        }
        if (this.replyTo != null) {
            msg.setReplyTo(this.replyTo.toArray(new Address[this.replyTo.size()]));
        }
        if (this.to != null) {
            msg.addRecipients(Message.RecipientType.TO, this.to.toArray(new Address[this.to.size()]));
        }
        if (this.cc != null) {
            msg.addRecipients(Message.RecipientType.CC, this.cc.toArray(new Address[this.cc.size()]));
        }
        if (this.bcc != null) {
            msg.addRecipients(Message.RecipientType.BCC, this.bcc.toArray(new Address[this.bcc.size()]));
        }
        msg.setSubject(this.subject, StandardCharsets.UTF_8.name());
        if (this.content != null) {
            msg.setContent(this.content, this.contentType);
        }
        if (this.sentDate != null) {
            msg.setSentDate(this.sentDate);
        }
        if (this.msgInit != null) {
            this.msgInit.accept(msg);
        }
        return msg;
    }

    protected List<Address> getFrom() {
        if (this.from == null) {
            this.from = new ArrayList<Address>();
        }
        return this.from;
    }

    protected List<Address> getReplyTo() {
        if (this.replyTo == null) {
            this.replyTo = new ArrayList<Address>();
        }
        return this.replyTo;
    }

    protected List<Address> getTo() {
        if (this.to == null) {
            this.to = new ArrayList<Address>();
        }
        return this.to;
    }

    protected List<Address> getCc() {
        if (this.cc == null) {
            this.cc = new ArrayList<Address>();
        }
        return this.cc;
    }

    protected List<Address> getBcc() {
        if (this.bcc == null) {
            this.bcc = new ArrayList<Address>();
        }
        return this.bcc;
    }
}

