/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.utils.DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;

public class SqlDateTimeAdapter
implements JsonSerializer<Timestamp>,
JsonDeserializer<Timestamp> {
    public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(DateUtils.newDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(src));
    }

    public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return new Timestamp(DateUtils.newDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(json.getAsString()).getTime());
        }
        catch (ParseException ex) {
            throw new JsonParseException((Throwable)ex);
        }
    }
}

