/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.json.JsonException;
import com.appslandia.common.json.JsonIgnore;
import com.appslandia.common.json.JsonProcessor;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;
import javax.json.bind.config.PropertyVisibilityStrategy;

public class JsonbProcessor
extends JsonProcessor {
    private Jsonb jsonb;
    private JsonbConfig config;

    @Override
    protected void init() throws Exception {
        if (this.config == null) {
            this.config = JsonbProcessor.newConfig();
        }
        this.jsonb = JsonbBuilder.create((JsonbConfig)this.config);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.jsonb != null) {
            try {
                this.jsonb.close();
            }
            catch (Exception ex) {
                throw new DestroyException(ex);
            }
        }
    }

    @Override
    public void write(Writer out, Object obj) throws JsonException {
        this.initialize();
        try {
            this.jsonb.toJson(obj, out);
        }
        catch (JsonbException ex) {
            throw new JsonException(ex);
        }
    }

    @Override
    public <T> T read(Reader reader, Class<T> resultClass) throws JsonException {
        this.initialize();
        try {
            return (T)this.jsonb.fromJson(reader, resultClass);
        }
        catch (JsonbException ex) {
            throw new JsonException(ex);
        }
    }

    @Override
    public <T> T read(Reader reader, Type type) throws JsonException {
        this.initialize();
        try {
            return (T)this.jsonb.fromJson(reader, type);
        }
        catch (JsonbException ex) {
            throw new JsonException(ex);
        }
    }

    public JsonbProcessor setConfig(JsonbConfig config) {
        this.assertNotInitialized();
        this.config = config;
        return this;
    }

    public static JsonbConfig newConfig() {
        JsonbConfig config = new JsonbConfig();
        config.withPropertyVisibilityStrategy(new PropertyVisibilityStrategy(){

            public boolean isVisible(Field field) {
                return field.getDeclaredAnnotation(JsonIgnore.class) == null;
            }

            public boolean isVisible(Method method) {
                return false;
            }
        });
        config.withBinaryDataStrategy("BASE_64_URL");
        return config;
    }
}

