/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.json.DateAdapter;
import com.appslandia.common.json.JsonException;
import com.appslandia.common.json.JsonIgnore;
import com.appslandia.common.json.JsonProcessor;
import com.appslandia.common.json.SqlDateAdapter;
import com.appslandia.common.json.SqlDateTimeAdapter;
import com.appslandia.common.json.SqlTimeAdapter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class GsonProcessor
extends JsonProcessor {
    private Gson gson;
    private GsonBuilder builder;

    @Override
    protected void init() throws Exception {
        if (this.builder == null) {
            this.builder = GsonProcessor.newBuilder();
        }
        this.gson = this.builder.create();
    }

    @Override
    public void write(Writer out, Object obj) throws JsonException {
        this.initialize();
        try {
            this.gson.toJson(obj, (Appendable)out);
        }
        catch (JsonIOException ex) {
            throw new JsonException(ex);
        }
    }

    @Override
    public <T> T read(Reader reader, Class<T> resultClass) throws JsonException {
        this.initialize();
        try {
            return (T)this.gson.fromJson(reader, resultClass);
        }
        catch (JsonSyntaxException ex) {
            throw new JsonException(ex);
        }
        catch (JsonIOException ex) {
            throw new JsonException(ex);
        }
    }

    @Override
    public <T> T read(Reader reader, Type type) throws JsonException {
        this.initialize();
        try {
            return (T)this.gson.fromJson(reader, type);
        }
        catch (JsonSyntaxException ex) {
            throw new JsonException(ex);
        }
        catch (JsonIOException ex) {
            throw new JsonException(ex);
        }
    }

    public GsonProcessor setBuilder(GsonBuilder builder) {
        this.assertNotInitialized();
        this.builder = builder;
        return this;
    }

    public static GsonBuilder newBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes attrs) {
                return attrs.getAnnotation(JsonIgnore.class) != null;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.getDeclaredAnnotation(JsonIgnore.class) != null;
            }
        }});
        builder.registerTypeAdapter(java.util.Date.class, (Object)new DateAdapter());
        builder.registerTypeAdapter(Date.class, (Object)new SqlDateAdapter());
        builder.registerTypeAdapter(Time.class, (Object)new SqlTimeAdapter());
        builder.registerTypeAdapter(Timestamp.class, (Object)new SqlDateTimeAdapter());
        return builder;
    }
}

