/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jpa;

import com.appslandia.common.jdbc.SqlLikeEscaper;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class QueryAccessor
implements Query {
    final Query q;

    public QueryAccessor(Query q) {
        this.q = q;
    }

    public int getCount() {
        long count = this.getCountLong();
        if (count > Integer.MAX_VALUE) {
            throw new ArithmeticException("getCount() is out of range.");
        }
        return (int)count;
    }

    public long getCountLong() {
        Number count = (Number)this.q.getSingleResult();
        AssertUtils.assertNotNull(count);
        return count.longValue();
    }

    public List<Object[]> getList() {
        return (List)ObjectUtils.cast(this.getResultList());
    }

    public Object[] getFirstOrNull() {
        List<Object[]> results = this.setQueryTop(1).getList();
        return !results.isEmpty() ? results.get(0) : null;
    }

    public QueryAccessor setQueryTop(int maxResults) {
        this.q.setFirstResult(0).setMaxResults(maxResults);
        return this;
    }

    public QueryAccessor setLike(String parameterName, String emptyOrValue) {
        AssertUtils.assertNotNull(emptyOrValue);
        this.q.setParameter(parameterName, (Object)(!emptyOrValue.isEmpty() ? "%" + SqlLikeEscaper.getDefault().escape(emptyOrValue) + "%" : emptyOrValue));
        return this;
    }

    public QueryAccessor setLikeStart(String parameterName, String emptyOrValue) {
        AssertUtils.assertNotNull(emptyOrValue);
        this.q.setParameter(parameterName, (Object)(!emptyOrValue.isEmpty() ? SqlLikeEscaper.getDefault().escape(emptyOrValue) + "%" : emptyOrValue));
        return this;
    }

    public QueryAccessor setLikeEnd(String parameterName, String emptyOrValue) {
        AssertUtils.assertNotNull(emptyOrValue);
        this.q.setParameter(parameterName, (Object)(!emptyOrValue.isEmpty() ? "%" + SqlLikeEscaper.getDefault().escape(emptyOrValue) : emptyOrValue));
        return this;
    }

    public Map<String, Object> getHints() {
        return this.q.getHints();
    }

    public int getFirstResult() {
        return this.q.getFirstResult();
    }

    public FlushModeType getFlushMode() {
        return this.q.getFlushMode();
    }

    public LockModeType getLockMode() {
        return this.q.getLockMode();
    }

    public int getMaxResults() {
        return this.q.getMaxResults();
    }

    public Parameter<?> getParameter(int position) {
        return this.q.getParameter(position);
    }

    public Parameter<?> getParameter(String name) {
        return this.q.getParameter(name);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this.q.getParameter(position, type);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.q.getParameter(name, type);
    }

    public Object getParameterValue(int position) {
        return this.q.getParameterValue(position);
    }

    public Object getParameterValue(String name) {
        return this.q.getParameterValue(name);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.q.getParameterValue(param);
    }

    public Set<Parameter<?>> getParameters() {
        return this.q.getParameters();
    }

    public List getResultList() {
        return this.q.getResultList();
    }

    public Stream getResultStream() {
        return this.q.getResultStream();
    }

    public Object getSingleResult() {
        return this.q.getSingleResult();
    }

    public QueryAccessor setHint(String hintName, Object value) {
        this.q.setHint(hintName, value);
        return this;
    }

    public QueryAccessor setFirstResult(int startPosition) {
        this.q.setFirstResult(startPosition);
        return this;
    }

    public QueryAccessor setFlushMode(FlushModeType flushMode) {
        this.q.setFlushMode(flushMode);
        return this;
    }

    public QueryAccessor setLockMode(LockModeType lockMode) {
        this.q.setLockMode(lockMode);
        return this;
    }

    public QueryAccessor setMaxResults(int maxResult) {
        this.q.setMaxResults(maxResult);
        return this;
    }

    public QueryAccessor setParameter(int position, Object value) {
        this.q.setParameter(position, value);
        return this;
    }

    public QueryAccessor setParameter(String name, Object value) {
        this.q.setParameter(name, value);
        return this;
    }

    public <T> QueryAccessor setParameter(Parameter<T> param, T value) {
        this.q.setParameter(param, value);
        return this;
    }

    public QueryAccessor setParameter(int position, Calendar value, TemporalType temporalType) {
        this.q.setParameter(position, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(int position, Date value, TemporalType temporalType) {
        this.q.setParameter(position, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(String name, Calendar value, TemporalType temporalType) {
        this.q.setParameter(name, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(String name, Date value, TemporalType temporalType) {
        this.q.setParameter(name, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.q.setParameter(param, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.q.setParameter(param, value, temporalType);
        return this;
    }

    public int executeUpdate() {
        return this.q.executeUpdate();
    }

    public boolean isBound(Parameter<?> param) {
        return this.q.isBound(param);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.q.unwrap(cls);
    }
}

