/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jpa;

import com.appslandia.common.base.Out;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

public class JpaUtils {
    public static String generateInsertSql(Class<?> entityClass) {
        Entity entity = entityClass.getDeclaredAnnotation(Entity.class);
        AssertUtils.assertNotNull(entity, "entityClass is not entity class.");
        Table table = entityClass.getDeclaredAnnotation(Table.class);
        final StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        if (table == null || table.name().isEmpty()) {
            builder.append(!entity.name().isEmpty() ? entity.name() : entityClass.getSimpleName());
        } else if (!table.catalog().isEmpty()) {
            AssertUtils.assertTrue(!table.schema().isEmpty());
            builder.append(table.catalog()).append('.').append(table.schema()).append('.').append(table.name());
        } else if (!table.schema().isEmpty()) {
            builder.append(table.schema()).append('.').append(table.name());
        } else {
            builder.append(table.name());
        }
        builder.append(" (");
        final Out<Boolean> firstCol = new Out<Boolean>(true);
        ReflectionUtils.traverse(entityClass, new ReflectionUtils.FieldHandler(){

            @Override
            public boolean matches(Field field) {
                return JpaUtils.isInsertField(field);
            }

            @Override
            public boolean handle(Field field) throws ReflectionException {
                if (((Boolean)firstCol.value()).booleanValue()) {
                    builder.append(JpaUtils.getColumnName(field));
                    firstCol.value = false;
                } else {
                    builder.append(',').append(JpaUtils.getColumnName(field));
                }
                return true;
            }
        });
        builder.append(") VALUES (");
        firstCol.value = true;
        ReflectionUtils.traverse(entityClass, new ReflectionUtils.FieldHandler(){

            @Override
            public boolean matches(Field field) {
                return JpaUtils.isInsertField(field);
            }

            @Override
            public boolean handle(Field field) throws ReflectionException {
                if (((Boolean)firstCol.value()).booleanValue()) {
                    builder.append('@').append(JpaUtils.getColumnName(field));
                    firstCol.value = false;
                } else {
                    builder.append(",@").append(JpaUtils.getColumnName(field));
                }
                return true;
            }
        });
        builder.append(")");
        return builder.toString();
    }

    static String getColumnName(Field field) {
        Column column = field.getDeclaredAnnotation(Column.class);
        if (column == null || column.name().isEmpty()) {
            return field.getName();
        }
        return column.name();
    }

    static boolean isInsertField(Field field) {
        if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        if (field.getDeclaredAnnotation(Transient.class) != null) {
            return false;
        }
        if (field.getDeclaredAnnotation(OneToOne.class) != null || field.getDeclaredAnnotation(OneToMany.class) != null || field.getDeclaredAnnotation(ManyToOne.class) != null) {
            return false;
        }
        if (field.getDeclaredAnnotation(JoinTable.class) != null || field.getDeclaredAnnotation(JoinColumn.class) != null || field.getDeclaredAnnotation(JoinColumns.class) != null) {
            return false;
        }
        GeneratedValue gv = field.getDeclaredAnnotation(GeneratedValue.class);
        if (gv == null) {
            return true;
        }
        return gv.strategy() != GenerationType.IDENTITY && gv.strategy() != GenerationType.SEQUENCE;
    }
}

