/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jpa;

import com.appslandia.common.base.Params;
import com.appslandia.common.jpa.QueryAccessor;
import com.appslandia.common.jpa.TypedQueryAccessor;
import java.util.List;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;

public class EntityManagerAccessor
implements EntityManager {
    private EntityManager em;

    public EntityManagerAccessor() {
    }

    public EntityManagerAccessor(EntityManager em) {
        this.em = em;
    }

    public void insert(Object entity) {
        this.em.persist(entity);
        this.em.flush();
    }

    public void insertRefresh(Object entity) {
        this.em.persist(entity);
        this.em.flush();
        this.em.refresh(entity);
    }

    public void removeByPk(Class<?> type, Object primaryKey) throws EntityNotFoundException {
        Object ref = this.em.getReference(type, primaryKey);
        this.em.remove(ref);
    }

    public boolean isInCache(Class<?> type, Object primaryKey) {
        Cache cache = this.em.getEntityManagerFactory().getCache();
        return cache != null && cache.contains(type, primaryKey);
    }

    public void evictCache() {
        Cache cache = this.em.getEntityManagerFactory().getCache();
        if (cache != null) {
            cache.evictAll();
        }
    }

    public void evictCache(Class<?> type) {
        Cache cache = this.em.getEntityManagerFactory().getCache();
        if (cache != null) {
            cache.evict(type);
        }
    }

    public void evictCache(Class<?> type, Object primaryKey) {
        Cache cache = this.em.getEntityManagerFactory().getCache();
        if (cache != null) {
            cache.evict(type, primaryKey);
        }
    }

    public <T> T findFetchGraph(Class<T> entityClass, Object primaryKey, String graphName) {
        return (T)this.em.find(entityClass, primaryKey, (Map)new Params(1).put("javax.persistence.fetchgraph", (Object)this.em.createEntityGraph(graphName)));
    }

    public <T> T findLoadGraph(Class<T> entityClass, Object primaryKey, String graphName) {
        return (T)this.em.find(entityClass, primaryKey, (Map)new Params(1).put("javax.persistence.loadgraph", (Object)this.em.createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createQueryFetchGraph(String qlString, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.em.createQuery(qlString, resultClass).setHint("javax.persistence.fetchgraph", (Object)this.em.createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createQueryLoadGraph(String qlString, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.em.createQuery(qlString, resultClass).setHint("javax.persistence.loadgraph", (Object)this.em.createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createNamedQueryFetchGraph(String name, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.em.createNamedQuery(name, resultClass).setHint("javax.persistence.fetchgraph", (Object)this.em.createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createNamedQueryLoadGraph(String name, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.em.createNamedQuery(name, resultClass).setHint("javax.persistence.loadgraph", (Object)this.em.createEntityGraph(graphName)));
    }

    public void remove(Object entity) {
        this.em.remove(entity);
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.em.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.em.lock(entity, lockMode, properties);
    }

    public void setProperty(String propertyName, Object value) {
        this.em.setProperty(propertyName, value);
    }

    public void clear() {
        this.em.clear();
    }

    public boolean contains(Object entity) {
        return this.em.contains(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.em.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.em.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.em.find(entityClass, primaryKey, lockMode, properties);
    }

    public Map<String, Object> getProperties() {
        return this.em.getProperties();
    }

    public void close() {
        this.em.close();
    }

    public void flush() {
        this.em.flush();
    }

    public <T> T merge(T entity) {
        return (T)this.em.merge(entity);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.em.unwrap(cls);
    }

    public boolean isOpen() {
        return this.em.isOpen();
    }

    public void detach(Object entity) {
        this.em.detach(entity);
    }

    public QueryAccessor createNativeQuery(String sqlString, Class resultClass) {
        return new QueryAccessor(this.em.createNativeQuery(sqlString, resultClass));
    }

    public QueryAccessor createNativeQuery(String sqlString) {
        return new QueryAccessor(this.em.createNativeQuery(sqlString));
    }

    public QueryAccessor createNativeQuery(String sqlString, String resultSetMapping) {
        return new QueryAccessor(this.em.createNativeQuery(sqlString, resultSetMapping));
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.em.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.em.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.em.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return this.em.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public boolean isJoinedToTransaction() {
        return this.em.isJoinedToTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.em.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.em.getCriteriaBuilder();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.em.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.em.createEntityGraph(graphName);
    }

    public void persist(Object entity) {
        this.em.persist(entity);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.getReference(entityClass, primaryKey);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.em.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.em.getFlushMode();
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.em.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.em.refresh(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.em.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.em.refresh(entity, properties);
    }

    public LockModeType getLockMode(Object entity) {
        return this.em.getLockMode(entity);
    }

    public <T> TypedQueryAccessor<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new TypedQueryAccessor(this.em.createQuery(criteriaQuery));
    }

    public <T> TypedQueryAccessor<T> createQuery(String qlString, Class<T> resultClass) {
        return new TypedQueryAccessor(this.em.createQuery(qlString, resultClass));
    }

    public QueryAccessor createQuery(CriteriaUpdate updateQuery) {
        return new QueryAccessor(this.em.createQuery(updateQuery));
    }

    public QueryAccessor createQuery(CriteriaDelete deleteQuery) {
        return new QueryAccessor(this.em.createQuery(deleteQuery));
    }

    public QueryAccessor createQuery(String qlString) {
        return new QueryAccessor(this.em.createQuery(qlString));
    }

    public <T> TypedQueryAccessor<T> createNamedQuery(String name, Class<T> resultClass) {
        return new TypedQueryAccessor(this.em.createNamedQuery(name, resultClass));
    }

    public QueryAccessor createNamedQuery(String name) {
        return new QueryAccessor(this.em.createNamedQuery(name));
    }

    public void joinTransaction() {
        this.em.joinTransaction();
    }

    public Object getDelegate() {
        return this.em.getDelegate();
    }

    public EntityTransaction getTransaction() {
        return this.em.getTransaction();
    }

    public Metamodel getMetamodel() {
        return this.em.getMetamodel();
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.em.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.em.getEntityGraphs(entityClass);
    }
}

