/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.jose.JoseHeader;
import com.appslandia.common.jose.JwtPayload;
import com.appslandia.common.utils.AssertUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class JwtToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    final JoseHeader header;
    final JwtPayload payload;

    public JwtToken(JoseHeader header, JwtPayload payload) {
        this.header = AssertUtils.assertNotNull(header);
        this.payload = AssertUtils.assertNotNull(payload);
    }

    public JoseHeader getHeader() {
        return this.header;
    }

    public JwtPayload getPayload() {
        return this.payload;
    }

    public String getIssuer() {
        return this.payload.getIssuer();
    }

    public String getSubject() {
        return this.payload.getSubject();
    }

    public List<String> getAudiences() {
        return this.payload.getAudiences();
    }

    public Date getExpiresAt() {
        return this.payload.getExpiresAt();
    }

    public Date getNotBefore() {
        return this.payload.getNotBefore();
    }

    public Date getIssuedAt() {
        return this.payload.getIssuedAt();
    }

    public String getJwtId() {
        return this.payload.getJwtId();
    }

    public Long getLong(String key) {
        return this.payload.getLong(key);
    }

    public Long getRequiredLong(String key) throws NullPointerException {
        return this.payload.getRequiredLong(key);
    }

    public Double getDouble(String key) {
        return this.payload.getDouble(key);
    }

    public Double getRequiredDouble(String key) throws NullPointerException {
        return this.payload.getRequiredDouble(key);
    }

    public <T> T getObject(String key) {
        return this.payload.getObject(key);
    }

    public <T> T getRequiredObject(String key) throws NullPointerException {
        return this.payload.getRequiredObject(key);
    }

    public Date getNumericDate(String key) {
        return this.payload.getNumericDate(key);
    }

    public Date getRequiredNumericDate(String key) throws NullPointerException {
        return this.payload.getRequiredNumericDate(key);
    }
}

