/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.jose.JoseHeader;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import java.io.Serializable;

public class JwsToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JoseHeader header;
    private byte[] payload;

    public JwsToken(JoseHeader header, String payload) {
        this(header, AssertUtils.assertNotNull(payload).getBytes(CharsetUtils.UTF_8));
    }

    public JwsToken(JoseHeader header, byte[] payload) {
        this.header = AssertUtils.assertNotNull(header);
        this.payload = AssertUtils.assertNotNull(payload);
    }

    public JoseHeader getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadAsString() {
        return new String(this.payload, CharsetUtils.UTF_8);
    }
}

