/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.jose.JoseException;
import com.appslandia.common.jose.JoseHeader;
import com.appslandia.common.jose.JoseSigner;
import com.appslandia.common.jose.JoseUtils;
import com.appslandia.common.jose.JoseVerifier;
import com.appslandia.common.jose.JwsToken;
import com.appslandia.common.json.JsonException;
import com.appslandia.common.json.JsonProcessor;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ValueUtils;
import java.io.StringReader;
import java.util.Set;

public class JwsProcessor
extends InitializeObject {
    protected JsonProcessor jsonProcessor;
    protected Set<String> numericDateProps;
    protected JoseSigner joseSigner;
    protected long leewayMs;
    protected final JoseVerifier<JoseHeader> headerVerifier = new JoseVerifier();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.jsonProcessor, "jsonProcessor is required.");
        this.numericDateProps = CollectionUtils.unmodifiable(this.numericDateProps);
        this.joseSigner = ValueUtils.valueOrAlt(this.joseSigner, JoseSigner.NONE);
        AssertUtils.assertTrue(this.leewayMs >= 0L, "leewayMs is invalid.");
        this.initHeaderVerifier();
    }

    protected void initHeaderVerifier() {
        this.headerVerifier.addVerifier(new JoseVerifier.Delegate<JoseHeader, JoseSigner>(this.joseSigner){

            @Override
            public void verify(JoseHeader obj, boolean parsing) throws JoseException {
                if (obj.getAlgorithm() == null) {
                    throw new JoseException("alg is required.");
                }
                if (!obj.getAlgorithm().equals(((JoseSigner)this.arg).getAlgorithm())) {
                    throw new JoseException("alg is not matched.");
                }
                if (!ObjectUtils.equals(obj.getKid(), ((JoseSigner)this.arg).getKid())) {
                    throw new JoseException("kid is not matched.");
                }
            }
        });
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.jsonProcessor != null) {
            this.jsonProcessor.destroy();
        }
        if (this.joseSigner != null) {
            this.joseSigner.destroy();
        }
    }

    public JoseHeader newHeader() {
        this.initialize();
        return new JoseHeader().setAlgorithm(this.joseSigner.getAlgorithm()).setKid(this.joseSigner.getKid());
    }

    public String compact(JwsToken jws) throws CryptoException, JsonException, JoseException {
        return this.compact(jws, true);
    }

    public String compact(JwsToken jws, boolean verify) throws CryptoException, JsonException, JoseException {
        this.initialize();
        AssertUtils.assertNotNull(jws);
        AssertUtils.assertNotNull(jws.getHeader());
        AssertUtils.assertNotNull(jws.getPayload());
        if (verify) {
            this.headerVerifier.verify(jws.getHeader(), false);
        }
        StringWriter out = new StringWriter();
        this.jsonProcessor.write(out, jws.getHeader());
        String base64Header = BaseEncoder.BASE64_URL_NP.encode(out.toString().getBytes(CharsetUtils.UTF_8));
        String base64Payload = BaseEncoder.BASE64_URL_NP.encode(jws.getPayload());
        if (this.joseSigner == JoseSigner.NONE) {
            return base64Header + "." + base64Payload + ".";
        }
        String dataToSign = base64Header + "." + base64Payload;
        String base64Sig = BaseEncoder.BASE64_URL_NP.encode(this.joseSigner.sign(dataToSign.getBytes(CharsetUtils.UTF_8)));
        return dataToSign + "." + base64Sig;
    }

    public JwsToken parse(String jws) throws CryptoException, JsonException, JoseException {
        return this.parse(jws, true);
    }

    public JwsToken parse(String jws, boolean verify) throws CryptoException, JsonException, JoseException {
        this.initialize();
        AssertUtils.assertNotNull(jws);
        String[] parts = JoseUtils.parseParts(jws);
        if (parts == null) {
            throw new JoseException("jws is invalid.");
        }
        if (parts[2] == null) {
            if (this.joseSigner != JoseSigner.NONE) {
                throw new JoseException("Signature is required.");
            }
            return this.doParse(parts[0], parts[1], verify);
        }
        String dataToSign = parts[0] + "." + parts[1];
        byte[] signature = BaseEncoder.BASE64_URL_NP.decode(parts[2]);
        if (!this.joseSigner.verify(dataToSign.getBytes(CharsetUtils.UTF_8), signature)) {
            throw new JoseException("Failed to verify signature.");
        }
        return this.doParse(parts[0], parts[1], verify);
    }

    protected JwsToken doParse(String headerPart, String payloadPart, boolean verify) throws JsonException, JoseException {
        JoseHeader header = this.parseHeader(headerPart);
        if (verify) {
            this.headerVerifier.verify(header, true);
        }
        byte[] payload = this.parsePayload(payloadPart);
        return new JwsToken(header, payload);
    }

    public JoseHeader parseHeader(String headerPart) throws JsonException, JoseException {
        this.initialize();
        AssertUtils.assertNotNull(headerPart);
        String headerJson = new String(BaseEncoder.BASE64_URL_NP.decode(headerPart), CharsetUtils.UTF_8);
        JoseHeader header = new JoseHeader(this.jsonProcessor.readAsLinkedMap(new StringReader(headerJson)));
        JoseUtils.convertToLong(header, this.numericDateProps);
        return header;
    }

    public byte[] parsePayload(String payloadPart) {
        this.initialize();
        AssertUtils.assertNotNull(payloadPart);
        return BaseEncoder.BASE64_URL_NP.decode(payloadPart);
    }

    public JwsProcessor setJsonProcessor(JsonProcessor jsonProcessor) {
        this.assertNotInitialized();
        this.jsonProcessor = jsonProcessor;
        return this;
    }

    public JwsProcessor setNumericDateProps(String ... numericDateProps) {
        this.assertNotInitialized();
        if (numericDateProps != null) {
            this.numericDateProps = CollectionUtils.toSet(numericDateProps);
        }
        return this;
    }

    public JwsProcessor setJoseSigner(JoseSigner joseSigner) {
        this.assertNotInitialized();
        this.joseSigner = joseSigner;
        return this;
    }

    public <A> JwsProcessor addHeaderVerifier(JoseVerifier.Delegate<JoseHeader, A> delegate) {
        this.assertNotInitialized();
        this.headerVerifier.addVerifier(delegate);
        return this;
    }

    public JwsProcessor setLeewayMs(long leewayMs) {
        this.assertNotInitialized();
        this.leewayMs = leewayMs;
        return this;
    }
}

